/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.membership;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3.operation.MergeOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipDAOHibernate
extends HibernateDao
implements MembershipDao,
InternalMembershipDao {
    private UserDAOHibernate userDao;
    private GroupDAOHibernate groupDao;
    private HQLQueryTranslater hqlQueryTranslater;

    @Override
    public Class getPersistentClass() {
        return InternalMembership.class;
    }

    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws GroupNotFoundException {
        ArrayList failedUsers = new ArrayList();
        Collection<InternalUser> internalUsers = this.userDao.findByNames(directoryId, userNames);
        InternalGroup group = this.groupDao.findByName(directoryId, groupName);
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        for (InternalUser user : internalUsers) {
            memberships.add(new InternalMembership(group, user));
        }
        BatchResult<InternalMembership> daoResult = this.addAll(memberships);
        BatchResult result = new BatchResult(daoResult.getTotalSuccessful());
        for (InternalMembership internalMembership : daoResult.getSuccessfulEntities()) {
            result.addSuccess((Object)internalMembership.getChildName());
        }
        for (InternalMembership internalMembership : daoResult.getFailedEntities()) {
            result.addFailure((Object)internalMembership.getChildName());
        }
        return result;
    }

    public boolean isUserDirectMember(long directoryId, String username, String groupName) {
        try {
            this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
            return true;
        }
        catch (MembershipNotFoundException e) {
            return false;
        }
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        try {
            this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
            return true;
        }
        catch (MembershipNotFoundException e) {
            return false;
        }
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws UserNotFoundException, GroupNotFoundException {
        InternalUser internalUser = this.userDao.findByName(directoryId, username);
        InternalGroup internalGroup = this.groupDao.findByName(directoryId, groupName);
        super.save(new InternalMembership(internalGroup, internalUser));
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
        super.remove(internalMembership);
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws GroupNotFoundException {
        InternalGroup internalChildGroup = this.groupDao.findByName(directoryId, childGroup);
        InternalGroup internalParentGroup = this.groupDao.findByName(directoryId, parentGroup);
        super.save(new InternalMembership(internalParentGroup, internalChildGroup));
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws MembershipNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
        super.remove(internalMembership);
    }

    @Override
    public void removeGroupMembers(final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllEntityMembers").setString("entityName", IdentifierUtils.toLowerCase((String)groupName)).setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    @Override
    public void removeGroupMemberships(final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllEntityMemberships").setString("entityName", IdentifierUtils.toLowerCase((String)groupName)).setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
            }
        });
    }

    @Override
    public void removeUserMemberships(final long directoryId, final String username) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllEntityMemberships").setString("entityName", IdentifierUtils.toLowerCase((String)username)).setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    @Override
    public void removeAllRelationships(final long directoryId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllRelationships").setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    @Override
    public void removeAllUserRelationships(final long directoryId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllRelationshipsOfType").setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    public <T> List<T> search(final long directoryId, final MembershipQuery<T> query) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = MembershipDAOHibernate.this.hqlQueryTranslater.asHQL(directoryId, query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    private InternalMembership findInternalMembership(final long directoryId, final String childName, final String parentName, final MembershipType type) throws MembershipNotFoundException {
        InternalMembership internalMembership = (InternalMembership)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, MembershipDAOHibernate.this.getPersistentClass()).add((Criterion)Expression.eq((String)"directory.id", (Object)directoryId)).add((Criterion)Expression.eq((String)"lowerParentName", (Object)IdentifierUtils.toLowerCase((String)parentName))).add((Criterion)Expression.eq((String)"lowerChildName", (Object)IdentifierUtils.toLowerCase((String)childName))).add((Criterion)Expression.eq((String)"membershipType", (Object)type)).uniqueResult();
            }
        });
        if (internalMembership == null) {
            throw new MembershipNotFoundException(childName, parentName);
        }
        return internalMembership;
    }

    @Override
    public void renameUserRelationships(final long directoryId, final String oldName, final String newName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    @Override
    public void renameGroupRelationships(final long directoryId, final String oldName, final String newName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
                session.getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
                return session.getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    public List<InternalMembership> findAll(final Collection<Directory> directories) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, MembershipDAOHibernate.this.getPersistentClass()).add(Restrictions.in((String)"directory", (Collection)directories)).list();
            }
        });
    }

    @Override
    public BatchResult<InternalMembership> addAll(Set<InternalMembership> memberships) {
        return this.batchProcessor.execute(new MergeOperation(), memberships);
    }

    public void setUserDao(UserDAOHibernate userDao) {
        this.userDao = userDao;
    }

    public void setGroupDao(GroupDAOHibernate groupDao) {
        this.groupDao = groupDao;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

