/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.user.AutoUserCreatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedAuthenticationDirectory
implements RemoteDirectory {
    private static final Logger logger = Logger.getLogger(DelegatedAuthenticationDirectory.class);
    public static final String ATTRIBUTE_CREATE_USER_ON_AUTH = "crowd.delegated.directory.auto.create.user";
    public static final String ATTRIBUTE_LDAP_DIRECTORY_CLASS = "crowd.delegated.directory.type";
    private final RemoteDirectory ldapDirectory;
    private final RemoteDirectory internalDirectory;
    private final EventPublisher eventPublisher;
    private final DirectoryDao directoryDao;

    public DelegatedAuthenticationDirectory(RemoteDirectory ldapDirectory, RemoteDirectory internalDirectory, EventPublisher eventPublisher, DirectoryDao directoryDao) {
        this.ldapDirectory = ldapDirectory;
        this.internalDirectory = internalDirectory;
        this.eventPublisher = eventPublisher;
        this.directoryDao = directoryDao;
    }

    public long getDirectoryId() {
        return this.internalDirectory.getDirectoryId();
    }

    public void setDirectoryId(long directoryId) {
        throw new UnsupportedOperationException("You cannot mutate the directoryID of " + this.getClass().getName());
    }

    public String getDescriptiveName() {
        return "Delegated Authentication Directory";
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("You cannot mutate the attributes of " + this.getClass().getName());
    }

    public User findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserByName(name);
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserWithAttributesByName(name);
    }

    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        User user;
        block8: {
            try {
                user = this.findUserByName(name);
                if (user.isActive()) {
                    try {
                        this.ldapDirectory.authenticate(name, credential);
                        break block8;
                    }
                    catch (UserNotFoundException e) {
                        throw new InvalidAuthenticationException("Failed to authenticate principal, no credentials in authenticating delegate directory");
                    }
                }
                throw new InactiveAccountException(user.getName());
            }
            catch (UserNotFoundException e) {
                if (this.isUserCreateOnAuthEnabled()) {
                    User ldapUser = this.ldapDirectory.authenticate(name, credential);
                    try {
                        user = this.cloneLdapUserInternally(ldapUser);
                    }
                    catch (UserAlreadyExistsException e1) {
                        throw new OperationFailedException("User could not be found initially, but when cloning the user internally, user exists", (Throwable)e1);
                    }
                }
                throw e;
            }
        }
        return user;
    }

    private User cloneLdapUserInternally(User user) throws OperationFailedException, InvalidAuthenticationException, UserAlreadyExistsException {
        try {
            UserTemplate template = new UserTemplate(user.getName(), user.getDirectoryId());
            template.setActive(user.isActive());
            template.setDisplayName(user.getDisplayName());
            template.setFirstName(user.getFirstName());
            template.setLastName(user.getLastName());
            template.setEmailAddress(user.getEmailAddress());
            User createdUser = this.addUser(template, null);
            Directory dir = this.directoryDao.findById(createdUser.getDirectoryId());
            this.eventPublisher.publish((Object)new AutoUserCreatedEvent((Object)this, dir, createdUser));
            return createdUser;
        }
        catch (InvalidCredentialException e) {
            logger.error((Object)("Could not create authenticated user <" + user.getName() + "> in underlying InternalDirectory: " + e.getMessage()), (Throwable)e);
            throw new InvalidAuthenticationException(user.getName(), (Throwable)e);
        }
        catch (InvalidUserException e) {
            logger.error((Object)("Could not create authenticated user <" + user.getName() + "> in underlying InternalDirectory: " + e.getMessage()), (Throwable)e);
            throw new InvalidAuthenticationException(user.getName(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while cloning a user: " + e.getMessage());
        }
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        return this.internalDirectory.addUser(user, credential);
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        return this.internalDirectory.updateUser(user);
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        this.internalDirectory.updateUserCredential(username, credential);
    }

    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        return this.internalDirectory.renameUser(oldName, newName);
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.storeUserAttributes(username, attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.removeUserAttributes(username, attributeName);
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.removeUser(name);
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchUsers(query);
    }

    public Group findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupByName(name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupWithAttributesByName(name);
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        return this.internalDirectory.addGroup(group);
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        return this.internalDirectory.updateGroup(group);
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException, OperationFailedException {
        return this.internalDirectory.renameGroup(oldName, newName);
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.storeGroupAttributes(groupName, attributes);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.removeGroupAttributes(groupName, attributeName);
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.removeGroup(name);
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroups(query);
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        return this.internalDirectory.isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        return this.internalDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.addUserToGroup(username, groupName);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.removeUserFromGroup(username, groupName);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroupRelationships(query);
    }

    public void testConnection() throws OperationFailedException {
        this.ldapDirectory.testConnection();
    }

    public boolean supportsInactiveAccounts() {
        return this.internalDirectory.supportsInactiveAccounts();
    }

    public boolean supportsNestedGroups() {
        return this.internalDirectory.supportsNestedGroups();
    }

    public boolean isRolesDisabled() {
        return this.internalDirectory.isRolesDisabled();
    }

    public Set<String> getValues(String key) {
        return this.internalDirectory.getValues(key);
    }

    public String getValue(String key) {
        return this.internalDirectory.getValue(key);
    }

    public Set<String> getKeys() {
        return this.internalDirectory.getKeys();
    }

    public boolean isEmpty() {
        return this.internalDirectory.isEmpty();
    }

    public List<String> testUserSearch() throws OperationFailedException {
        return this.ldapDirectory.searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10));
    }

    private boolean isUserCreateOnAuthEnabled() {
        return Boolean.parseBoolean(this.getValue(ATTRIBUTE_CREATE_USER_ON_AUTH));
    }
}

