/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.validator;

import com.atlassian.crowd.directory.ldap.validator.Validator;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import org.apache.commons.lang.StringUtils;

public class GroupRoleDnOverlapValidator
implements Validator {
    public String getError(Directory directory) {
        String groupDN;
        String roleDN;
        boolean rolesDisabled = Boolean.parseBoolean(directory.getValue("ldap.roles.disabled"));
        DirectoryType directoryType = directory.getType();
        if (!rolesDisabled && DirectoryType.CONNECTOR.equals((Object)directoryType) && this.isDNConfigOverlapping(roleDN = directory.getValue("ldap.role.dn"), groupDN = directory.getValue("ldap.group.dn"))) {
            return "The supplied Role DN is invalid. It overlaps with the Group DN value.";
        }
        return null;
    }

    public boolean isDNConfigOverlapping(String roleDN, String groupDN) {
        if (StringUtils.isBlank((String)roleDN) || StringUtils.isBlank((String)groupDN)) {
            return true;
        }
        return StringUtils.startsWith((String)(roleDN = roleDN + ","), (String)(groupDN = groupDN + ",")) || StringUtils.startsWith((String)groupDN, (String)roleDN);
    }
}

