/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph.v22;

import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.osuser.CrowdCredentialsProvider;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdHttpAuthenticationFactory;
import com.atlassian.crowd.integration.seraph.v22.CrowdAuthenticator;
import com.opensymphony.user.UserManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JIRAAuthenticator
extends CrowdAuthenticator {
    protected static final String JIRA_USER_DASHBOARD_CURRENT_PAGE = "jira.user.dashboard.current.page";

    public JIRAAuthenticator() {
        this(RestCrowdHttpAuthenticationFactory.getAuthenticator());
    }

    public JIRAAuthenticator(CrowdHttpAuthenticator crowdHttpAuthenticator) {
        super(crowdHttpAuthenticator);
    }

    @Override
    protected void logoutUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute(JIRA_USER_DASHBOARD_CURRENT_PAGE);
    }

    @Override
    protected void fetchUserInCache(String username) throws UserNotFoundException, InvalidAuthenticationException, OperationFailedException {
        for (Object credentialProvider : UserManager.getInstance().getCredentialsProviders()) {
            if (!(credentialProvider instanceof CrowdCredentialsProvider)) continue;
            ((CrowdCredentialsProvider)credentialProvider).fetchInCache(username);
        }
    }
}

