/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.user.CrowdUserDetails;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.AbstractAuthenticationToken;

public class CrowdSSOAuthenticationToken
extends AbstractAuthenticationToken {
    private static final String UNAUTHENTICATED_TOKEN_PRINCIPAL = "CROWD.SSO";
    private Object credentials;
    private Object principal;

    public CrowdSSOAuthenticationToken(String ssoToken) {
        this.credentials = ssoToken;
        this.principal = UNAUTHENTICATED_TOKEN_PRINCIPAL;
        this.setAuthenticated(false);
    }

    public CrowdSSOAuthenticationToken(CrowdUserDetails principal, String ssoToken, GrantedAuthority[] authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = ssoToken;
        super.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor containing GrantedAuthority[]s instead");
        }
        super.setAuthenticated(false);
    }
}

