/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.acegi.CrowdSSOAuthenticationDetails;
import com.atlassian.crowd.integration.acegi.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.acegi.RequestToApplicationMapper;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.savedrequest.SavedRequest;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;

public class CrowdSSOAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private HttpAuthenticator httpAuthenticator;
    private RequestToApplicationMapper requestToApplicationMapper;

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean usernamePasswordAuthentication = super.requiresAuthentication(request, response);
        if (!usernamePasswordAuthentication) {
            Authentication authenticatedToken = null;
            try {
                CrowdSSOAuthenticationToken crowdAuthRequest = new CrowdSSOAuthenticationToken(this.httpAuthenticator.getToken(request));
                this.doSetDetails(request, crowdAuthRequest);
                authenticatedToken = this.getAuthenticationManager().authenticate((Authentication)crowdAuthRequest);
            }
            catch (InvalidTokenException e) {
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
            if (authenticatedToken == null) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.getContext().setAuthentication(authenticatedToken);
                try {
                    this.onSuccessfulAuthentication(request, response, authenticatedToken);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return usernamePasswordAuthentication;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        this.doSetDetails(request, (AbstractAuthenticationToken)authRequest);
    }

    protected void doSetDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        String application;
        if (this.requestToApplicationMapper != null) {
            SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute("ACEGI_SAVED_REQUEST_KEY");
            String path = savedRequest != null ? savedRequest.getRequestURI().substring(savedRequest.getContextPath().length()) : request.getRequestURI().substring(request.getContextPath().length());
            application = this.requestToApplicationMapper.getApplication(path);
        } else {
            application = this.httpAuthenticator.getClientProperties().getApplicationName();
        }
        ValidationFactor[] validationFactors = this.httpAuthenticator.getValidationFactors(request);
        authRequest.setDetails((Object)new CrowdSSOAuthenticationDetails(application, validationFactors));
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (authResult instanceof CrowdSSOAuthenticationToken && authResult.getCredentials() != null) {
            try {
                this.httpAuthenticator.setPrincipalToken(request, response, authResult.getCredentials().toString());
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to set Crowd SSO token", (Throwable)e);
            }
        }
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to unset Crowd SSO token", (Throwable)e);
        }
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public void setRequestToApplicationMapper(RequestToApplicationMapper requestToApplicationMapper) {
        this.requestToApplicationMapper = requestToApplicationMapper;
    }
}

