/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph;

import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.util.RedirectUtils;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public abstract class CrowdAuthenticator
extends DefaultAuthenticator {
    private static final Logger logger = Logger.getLogger(CrowdAuthenticator.class);
    protected final HttpAuthenticator httpAuthenticator;
    protected final UserManager userManager;

    public CrowdAuthenticator(HttpAuthenticator httpAuthenticator, UserManager userManager) {
        this.httpAuthenticator = httpAuthenticator;
        this.userManager = userManager;
    }

    protected boolean authenticate(Principal user, String password) {
        return true;
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        try {
            this.logout(request, response);
            logger.debug((Object)"Authenticating user with Crowd");
            this.httpAuthenticator.authenticate(request, response, username, password);
            logger.debug((Object)"Updating user session for Seraph");
            return super.login(request, response, username, password, cookie);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String username, String password) throws AuthenticatorException {
        return this.login(httpServletRequest, httpServletResponse, username, password, false);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        try {
            logger.debug((Object)"Logging off from Crowd");
            this.httpAuthenticator.logoff(request, response);
            logger.debug((Object)"Invalidating user in Crowd-Seraph specific session variables");
            this.logoutUser(request);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)"Invalidating user in Seraph specific session variables");
        return super.logout(request, response);
    }

    protected boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        boolean authenticated = this.isTrustedAppsRequest(request);
        if (!authenticated) {
            try {
                authenticated = this.httpAuthenticator.isAuthenticated(request, response);
                if (authenticated && logger.isDebugEnabled()) {
                    logger.debug((Object)"User IS authenticated via the Crowd session-token");
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"User is NOT authenticated via the Crowd session-token");
                }
            }
            catch (Exception e) {
                logger.info((Object)"Error while attempting to check if user isAuthenticated with Crowd", (Throwable)e);
            }
        }
        if (!authenticated) {
            authenticated = this.autoLoginToCrowd(request, response);
            if (authenticated && logger.isDebugEnabled()) {
                logger.debug((Object)"Authenticated via Crowd-Seraph AutoLogin cookie");
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to authenticate via Crowd-Seraph AutoLogin cookie");
            }
        }
        if (!authenticated && RedirectUtils.isBasicAuthentication((HttpServletRequest)request, (String)this.getAuthType()) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            authenticated = true;
        }
        if (!authenticated) {
            logger.debug((Object)"Request is not authenticated, logging out the user");
            try {
                this.logoutUser(request);
                if (response != null) {
                    super.logout(request, response);
                }
            }
            catch (AuthenticatorException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            authenticated = false;
        }
        return authenticated;
    }

    protected boolean autoLoginToCrowd(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = CookieFactory.getCookieHandler().getCookie(request, this.getLoginCookieKey());
        if (cookie == null) {
            return false;
        }
        Object[] values = this.decodeCookie(cookie.getValue());
        if (ArrayUtils.isEmpty((Object[])values)) {
            return false;
        }
        Object username = values[0];
        Object password = values[1];
        logger.debug((Object)"Got username and password from auto-login cookie, attempting to authenticate user");
        try {
            this.httpAuthenticator.authenticate(request, response, (String)username, (String)password);
            logger.debug((Object)"User authenticated via auto-login cookie");
            return true;
        }
        catch (Exception e) {
            logger.debug((Object)("Could not auto-login authenticate user " + (String)username), (Throwable)e);
            if (response != null) {
                CookieFactory.getCookieHandler().invalidateCookie(request, response, this.getLoginCookieKey(), "/");
            }
            return false;
        }
    }

    abstract void logoutUser(HttpServletRequest var1);

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        Principal user = null;
        if (this.isTrustedAppsRequest(request)) {
            return this.getUserFromSession(request);
        }
        if (this.isAuthenticated(request, response)) {
            String cookieToken;
            try {
                cookieToken = this.httpAuthenticator.getToken(request);
                String sessionToken = (String)request.getSession().getAttribute(this.httpAuthenticator.getClientProperties().getSessionTokenKey());
                if (cookieToken != null && cookieToken.equals(sessionToken)) {
                    user = this.getUserFromSession(request);
                }
            }
            catch (InvalidTokenException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            if (user == null) {
                try {
                    SOAPPrincipal soapPrincipal = this.userManager.getUserFromToken(cookieToken);
                    user = this.getUser(soapPrincipal.getName());
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage(), (Throwable)e);
                }
                HttpSession session = request.getSession();
                session.setAttribute("seraph_defaultauthenticator_user", (Object)user);
                session.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
                session.setAttribute(this.httpAuthenticator.getClientProperties().getSessionTokenKey(), (Object)cookieToken);
            }
        }
        return user;
    }

    private boolean isTrustedAppsRequest(HttpServletRequest request) {
        if ("success".equals(request.getAttribute("os_authstatus"))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"User IS authenticated via previous filter/trusted apps");
            }
            return true;
        }
        return false;
    }
}

