/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.CachingManagerFactory;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.util.Assert;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class CrowdGroupManager
implements com.atlassian.user.GroupManager {
    private static final Logger logger = Logger.getLogger(CrowdGroupManager.class);
    private final RepositoryIdentifier repositoryIdentifier;
    private final GroupManager groupManager;
    private final GroupMembershipManager groupMembershipManager;

    public CrowdGroupManager(RepositoryIdentifier repositoryIdentifier) {
        this(repositoryIdentifier, CachingManagerFactory.getGroupManagerInstance(), CachingManagerFactory.getGroupMembershipManagerInstance());
    }

    public CrowdGroupManager(RepositoryIdentifier repositoryIdentifier, GroupManager groupManager, GroupMembershipManager groupMembershipManager) {
        this.repositoryIdentifier = repositoryIdentifier;
        this.groupManager = groupManager;
        this.groupMembershipManager = groupMembershipManager;
    }

    protected List getAllGroups() throws InvalidAuthorizationTokenException, RemoteException {
        List groupNames = this.groupManager.getAllGroupNames();
        return this.convertStringsToGroups(groupNames);
    }

    protected List convertStringsToGroups(List groupNames) {
        if (groupNames == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DefaultGroup> groups = new ArrayList<DefaultGroup>(groupNames.size());
        for (String name : groupNames) {
            groups.add(new DefaultGroup(name));
        }
        return groups;
    }

    public Pager getGroups() throws EntityException {
        try {
            return new DefaultPager((Collection)this.getAllGroups());
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public List getWritableGroups() {
        try {
            return this.getAllGroups();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            return new ArrayList(0);
        }
    }

    public Pager getGroups(User user) throws EntityException {
        return new DefaultPager((Collection)this.getGroupMemberships(user));
    }

    protected List getGroupMemberships(User user) throws EntityException {
        String userName = user.getName();
        try {
            List groupNames = this.groupMembershipManager.getMemberships(userName);
            return this.convertStringsToGroups(groupNames);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public Pager getMemberNames(Group group) throws EntityException {
        Assert.notNull(group);
        Assert.notNull(group.getName());
        try {
            List userNames = this.groupMembershipManager.getMembers(group.getName());
            return new DefaultPager((Collection)userNames);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.getMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return new DefaultPager(new ArrayList(0));
    }

    public Group getGroup(String name) throws EntityException {
        Assert.notNull(name);
        try {
            if (this.groupManager.isGroup(name)) {
                return new DefaultGroup(name);
            }
            return null;
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public Group createGroup(String name) throws EntityException {
        try {
            SOAPGroup group = new SOAPGroup();
            group.setActive(true);
            group.setDescription("");
            group.setName(name);
            this.groupManager.addGroup(group);
            return new DefaultGroup(name);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void removeGroup(Group group) throws EntityException {
        Assert.notNull(group);
        String groupName = group.getName();
        try {
            this.groupManager.removeGroup(groupName);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(groupName + " is not a member of this repository");
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void addMembership(Group group, User user) throws EntityException {
        Assert.notNull(group);
        Assert.notNull(user);
        Assert.notNull(group.getName());
        Assert.notNull(user.getName());
        try {
            this.groupMembershipManager.addMembership(user.getName(), group.getName());
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        Assert.notNull(group);
        Assert.notNull(user);
        try {
            boolean isMember = this.groupMembershipManager.isMember(user.getName(), group.getName());
            return isMember;
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void removeMembership(Group group, User user) throws EntityException {
        Assert.notNull(group);
        Assert.notNull(user);
        try {
            this.groupMembershipManager.removeMembership(user.getName(), group.getName());
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }
}

