/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap.xfire;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.OperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFireFaultLoggingMethodHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(XFireFaultLoggingMethodHandler.class);
    AbstractMessage faultMessage;

    public void invoke(MessageContext messageContext) throws Exception {
        if (logger.isDebugEnabled()) {
            MessageExchange messageExchange = messageContext.getExchange();
            OperationInfo operationInfo = messageExchange.getOperation();
            StringBuffer logMessage = new StringBuffer(512);
            logMessage.append("SOAP service fault for method: ").append(operationInfo.getName()).append("\n\t");
            if (messageExchange.getFaultMessage().getBody() instanceof XFireFault) {
                XFireFault fault = (XFireFault)messageExchange.getFaultMessage().getBody();
                if (fault.getCause() != null) {
                    logMessage.append(fault.getCause().toString());
                } else {
                    logMessage.append(fault.getMessage());
                }
            } else {
                logMessage.append("No cause or message for fault found.");
            }
            logMessage.append("\n");
            logger.debug(logMessage.toString());
        }
    }
}

