/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap.client;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidRoleException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import java.rmi.RemoteException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SecurityServerClient {
    public void authenticate() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public String authenticatePrincipal(UserAuthenticationContext var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public boolean isValidToken(String var1, ValidationFactor[] var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException;

    public void invalidateToken(String var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPGroup[] searchGroups(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPPrincipal[] searchPrincipals(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPRole[] searchRoles(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPGroup[] findAllGroups() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPRole[] findAllRoles() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPPrincipal[] findAllPrincipals() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPGroup addGroup(SOAPGroup var1) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException, InvalidAuthenticationException;

    public void updateGroup(String var1, String var2, boolean var3) throws RemoteException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPGroup findGroupByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException;

    public SOAPGroup findGroupWithAttributesByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException;

    public SOAPRole addRole(SOAPRole var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException, InvalidAuthenticationException;

    public SOAPRole findRoleByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException;

    public SOAPPrincipal findPrincipalByToken(String var1) throws RemoteException, InvalidTokenException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public void updatePrincipalAttribute(String var1, SOAPAttribute var2) throws RemoteException, UserNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public void updateGroupAttribute(String var1, SOAPAttribute var2) throws RemoteException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPPrincipal findPrincipalByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException;

    public SOAPPrincipal findPrincipalWithAttributesByName(String var1) throws RemoteException, UserNotFoundException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public void addAllPrincipals(Collection<SOAPPrincipalWithCredential> var1) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, BulkAddFailedException, InvalidAuthenticationException;

    public SOAPPrincipal addPrincipal(SOAPPrincipal var1, PasswordCredential var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, InvalidUserException, ApplicationPermissionException, InvalidAuthenticationException;

    public void addPrincipalToGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthenticationException;

    public void updatePrincipalCredential(String var1, PasswordCredential var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, InvalidAuthenticationException;

    public void resetPrincipalCredential(String var1) throws RemoteException, InvalidEmailAddressException, InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public void removeGroup(String var1) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException;

    public void removeRole(String var1) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException;

    public void removePrincipal(String var1) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException;

    public void addPrincipalToRole(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, InvalidAuthenticationException;

    public boolean isGroupMember(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public boolean isRoleMember(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public void removePrincipalFromGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, InvalidAuthenticationException;

    public void removePrincipalFromRole(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, InvalidAuthenticationException;

    public void addAttributeToPrincipal(String var1, SOAPAttribute var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException;

    public void removeAttributeFromPrincipal(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException;

    public void addAttributeToGroup(String var1, SOAPAttribute var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException;

    public void removeAttributeFromGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException;

    public long getCacheTime() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public boolean isCacheEnabled() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public String getDomain() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public String[] findAllPrincipalNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public String[] findAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SOAPNestableGroup[] findAllGroupRelationships() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public String[] findAllRoleNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public String[] findGroupMemberships(String var1) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException;

    public String[] findRoleMemberships(String var1) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException;

    public String authenticatePrincipalSimple(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public String createPrincipalToken(String var1, ValidationFactor[] var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException;

    public String[] getGrantedAuthorities() throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException;

    public SOAPCookieInfo getCookieInfo() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException;

    public SoapClientProperties getSoapClientProperties();
}

