package com.atlassian.crowd.service.client;

/**
 * Authentication methods known to the Rest Crowd Client.
 */
public enum AuthenticationMethod {
    BASIC_AUTH("basic_auth");

    private final String key;

    AuthenticationMethod(String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    public static AuthenticationMethod parse(String key) {
        for (AuthenticationMethod authenticationMethod : values()) {
            if (authenticationMethod.key.equals(key)) {
                return authenticationMethod;
            }
        }
        throw new IllegalArgumentException("Unknown authentication method: " + key);
    }
}
