package com.atlassian.crowd.integration.http;

import java.util.concurrent.locks.Lock;

/**
 * Provides locks for tokens.
 * Same instance of {@link TokenLockProvider} should be reused across all {@link CrowdHttpAuthenticator}s at runtime.
 */
@FunctionalInterface
public interface TokenLockProvider {

    /**
     * Returns lock for given token
     * @param token SSO token
     * @return lock
     */
    Lock getLock(String token);
}
