/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.client;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ResourceLocator;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClientPropertiesImpl
implements ClientProperties {
    private final Logger logger = Logger.getLogger(this.getClass());
    private String applicationName = null;
    private String applicationPassword = null;
    private String applicationAuthenticationURL = null;
    private String cookieTokenKey = null;
    private String sessionTokenKey = null;
    private String sessionLastValidation = null;
    private long sessionValidationInterval = 0L;
    private String baseURL = null;
    private String httpProxyPort = null;
    private String httpProxyHost = null;
    private String httpProxyUsername = null;
    private String httpProxyPassword = null;
    private String httpMaxConnections = null;
    private String httpTimeout = null;
    private ApplicationAuthenticationContext applicationAuthenticationContext = null;

    protected ClientPropertiesImpl() {
    }

    public void updateProperties(Properties properties) {
        this.applicationName = this.loadAndLogPropertyString(properties, "application.name");
        this.applicationPassword = this.loadPropertyString(properties, "application.password");
        this.applicationAuthenticationURL = this.loadAndLogPropertyString(properties, "application.login.url");
        this.cookieTokenKey = this.loadPropertyString(properties, "cookie.tokenkey");
        if (this.cookieTokenKey == null) {
            this.cookieTokenKey = "crowd.token_key";
        }
        this.sessionTokenKey = this.loadAndLogPropertyString(properties, "session.tokenkey");
        this.sessionLastValidation = this.loadAndLogPropertyString(properties, "session.lastvalidation");
        this.sessionValidationInterval = this.loadPropertyLong(properties, "session.validationinterval", true);
        this.httpProxyHost = this.loadPropertyString(properties, "http.proxy.host");
        this.httpProxyPort = this.loadPropertyString(properties, "http.proxy.port");
        this.httpProxyUsername = this.loadPropertyString(properties, "http.proxy.username");
        this.httpProxyPassword = this.loadPropertyString(properties, "http.proxy.password");
        this.httpMaxConnections = this.loadPropertyString(properties, "http.max.connections");
        this.httpTimeout = this.loadPropertyString(properties, "http.timeout");
        PasswordCredential credentials = new PasswordCredential(this.applicationPassword);
        this.applicationAuthenticationContext = new ApplicationAuthenticationContext();
        this.applicationAuthenticationContext.setName(this.applicationName);
        this.applicationAuthenticationContext.setCredential(credentials);
        this.baseURL = this.loadBaseURL(properties);
    }

    private long loadPropertyLong(Properties properties, String propertyName, boolean logProperty) {
        long propertyValue = 0L;
        String propertyValueAsString = logProperty ? this.loadAndLogPropertyString(properties, propertyName) : this.loadPropertyString(properties, propertyName);
        if (propertyValueAsString != null) {
            propertyValue = Long.parseLong(propertyValueAsString);
        }
        return propertyValue;
    }

    private String loadPropertyString(Properties properties, String propertyName) {
        String propertyValue = StringUtils.trimToNull((String)System.getProperty("crowd.property." + propertyName));
        if (propertyValue == null && properties != null && properties.containsKey(propertyName)) {
            propertyValue = StringUtils.trimToNull((String)properties.getProperty(propertyName));
        }
        return propertyValue;
    }

    protected String loadAndLogPropertyString(Properties properties, String propertyName) {
        String propertyValue = this.loadPropertyString(properties, propertyName);
        if (propertyValue != null) {
            this.logger.info((Object)("Loading property: '" + propertyName + "' : '" + propertyValue + "'"));
        } else {
            this.logger.info((Object)("Failed to find value for property: " + propertyName));
        }
        return propertyValue;
    }

    private String loadBaseURL(Properties properties) {
        String baseURL = this.loadPropertyString(properties, "crowd.base.url");
        if (StringUtils.isBlank((String)baseURL)) {
            baseURL = this.generateBaseURL(properties);
        }
        return StringUtils.removeEnd((String)baseURL, (String)"/");
    }

    private String generateBaseURL(Properties properties) {
        String url = this.loadPropertyString(properties, "crowd.server.url");
        int firstSlash = StringUtils.lastIndexOf((String)url, (String)"/services");
        if (firstSlash != -1) {
            url = url.substring(0, firstSlash);
        }
        return url;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public String getApplicationAuthenticationURL() {
        return this.applicationAuthenticationURL;
    }

    public String getCookieTokenKey() {
        return this.cookieTokenKey;
    }

    public String getSessionTokenKey() {
        return this.sessionTokenKey;
    }

    public String getSessionLastValidation() {
        return this.sessionLastValidation;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public ApplicationAuthenticationContext getApplicationAuthenticationContext() {
        return this.applicationAuthenticationContext;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public String getHttpMaxConnections() {
        return this.httpMaxConnections;
    }

    public String getHttpTimeout() {
        return this.httpTimeout;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    protected void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public static ClientPropertiesImpl newInstanceFromResourceLocator(ResourceLocator resourceLocator) {
        Properties properties = resourceLocator.getProperties();
        return ClientPropertiesImpl.newInstanceFromProperties(properties);
    }

    public static ClientPropertiesImpl newInstanceFromProperties(Properties properties) {
        ClientPropertiesImpl clientProperties = new ClientPropertiesImpl();
        clientProperties.updateProperties(properties);
        return clientProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientPropertiesGeneric");
        sb.append("{applicationName='").append(this.applicationName).append('\'');
        sb.append(", applicationPassword='").append(this.applicationPassword).append('\'');
        sb.append(", applicationAuthenticationURL='").append(this.applicationAuthenticationURL).append('\'');
        sb.append(", cookieTokenKey='").append(this.cookieTokenKey).append('\'');
        sb.append(", sessionTokenKey='").append(this.sessionTokenKey).append('\'');
        sb.append(", sessionLastValidation='").append(this.sessionLastValidation).append('\'');
        sb.append(", sessionValidationInterval=").append(this.sessionValidationInterval);
        sb.append(", baseURL='").append(this.baseURL).append('\'');
        sb.append(", httpProxyPort='").append(this.httpProxyPort).append('\'');
        sb.append(", httpProxyHost='").append(this.httpProxyHost).append('\'');
        sb.append(", httpProxyUsername='").append(this.httpProxyUsername).append('\'');
        sb.append(", httpProxyPassword='").append(this.httpProxyPassword).append('\'');
        sb.append(", httpMaxConnections='").append(this.httpMaxConnections).append('\'');
        sb.append(", httpTimeout='").append(this.httpTimeout).append('\'');
        sb.append(", applicationAuthenticationContext=").append(this.applicationAuthenticationContext);
        sb.append('}');
        return sb.toString();
    }
}

