package com.atlassian.crowd.model.user;

import java.io.Serializable;

public final class ImmutableUser extends BaseImmutableUser implements User, Serializable {
    public ImmutableUser(final User user) {
        super(builder(user));
    }

    public ImmutableUser(final long directoryId, final String name, final String displayName, final String emailAddress, final boolean active, final String firstName, final String lastName, final String externalId) {
        super(directoryId, name, displayName, emailAddress, active, firstName, lastName, externalId);
    }

    protected ImmutableUser(Builder builder) {
        super(builder);
    }

    @Override
    public ImmutableUser withName(String name) {
        return builder(this).name(name).build();
    }

    public static ImmutableUser from(User user) {
        if (user instanceof ImmutableUser) {
            return (ImmutableUser) user;
        }
        return builder(user).build();
    }

    public static Builder builder(User user) {
        return new Builder(user);
    }

    public static ImmutableUser.Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(long directoryId, String name) {
        return new Builder(directoryId, name);
    }

    public static class Builder extends BaseImmutableUser.Builder<Builder> {
        private Builder(User user) {
            super(user);
        }

        private Builder(String name) {
            super(name);
        }

        private Builder(long directoryId, String name) {
            super(directoryId, name);
        }

        @Override
        public ImmutableUser build() {
            return new ImmutableUser(this);
        }
    }
}
