/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameComparator {
    private static final UserNameComparator USER_NAME_COMPARATOR = new UserNameComparator();
    private static final GroupNameComparator GROUP_NAME_COMPARATOR = new GroupNameComparator();
    private static final StringNameComparator STRING_NAME_COMPARATOR = new StringNameComparator();

    private NameComparator() {
    }

    public static <T> Comparator<T> of(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return STRING_NAME_COMPARATOR;
        }
        if (User.class.isAssignableFrom(type)) {
            return USER_NAME_COMPARATOR;
        }
        if (Group.class.isAssignableFrom(type)) {
            return GROUP_NAME_COMPARATOR;
        }
        throw new IllegalStateException("Can't find name comparator for type " + type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringNameComparator
    implements Comparator<String> {
        private StringNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupNameComparator
    implements Comparator<Group> {
        private GroupNameComparator() {
        }

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserNameComparator
    implements Comparator<User> {
        private UserNameComparator() {
        }

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

