package com.atlassian.crowd.model.user;

import com.atlassian.crowd.embedded.api.UserComparator;

import com.google.common.base.Preconditions;

public final class ImmutableUser implements User {
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final String emailAddress;
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final String externalId;

    public ImmutableUser(final User user) {
        this(user.getDirectoryId(),
                user.getName(),
                user.getDisplayName(),
                user.getEmailAddress(),
                user.isActive(),
                user.getFirstName(),
                user.getLastName(),
                user.getExternalId());
    }

    public ImmutableUser(final long directoryId, final String name, final String displayName, final String emailAddress, final boolean active, final String firstName, final String lastName, final String externalId) {
        this.directoryId = directoryId;
        this.name = Preconditions.checkNotNull(name);
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.active = active;
        this.firstName = firstName;
        this.lastName = lastName;
        this.externalId = externalId;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public long getDirectoryId() {
        return directoryId;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getEmailAddress() {
        return emailAddress;
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public String getFirstName() {
        return firstName;
    }

    @Override
    public String getLastName() {
        return lastName;
    }

    @Override
    public String getExternalId() {
        return externalId;
    }

    @Override
    public boolean equals(final Object o) {
        return UserComparator.equalsObject(this, o);
    }

    @Override
    public int hashCode() {
        return UserComparator.hashCode(this);
    }

    @Override
    public int compareTo(final com.atlassian.crowd.embedded.api.User user) {
        return UserComparator.compareTo(this, user);
    }
}
