package com.atlassian.crowd.attribute;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class AttributePredicates {
    /**
     * Return true if the given attribute is a syncing attribute, ie. if the key starts with "synch."
     */
    public static final Predicate<String> SYNCING_ATTRIBUTE = key -> key.startsWith("synch.");

    /**
     * Return true if the given entry represents a syncing attribute.
     */
    public static final Predicate<Map.Entry<String, Set<String>>> SYNCHRONISABLE_ATTRIBUTE_ENTRY_PREDICATE =
            entry -> SYNCING_ATTRIBUTE.test(entry.getKey());

    private AttributePredicates() {
    }
}
