/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.client;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.BulkAddFailedException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import java.rmi.RemoteException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SecurityServerClient {
    public void authenticate() throws RemoteException, InvalidAuthorizationTokenException;

    public String authenticatePrincipal(UserAuthenticationContext var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public boolean isValidToken(String var1, ValidationFactor[] var2) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException;

    public void invalidateToken(String var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup[] searchGroups(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPPrincipal[] searchPrincipals(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPRole[] searchRoles(SearchRestriction[] var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup[] findAllGroups() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPRole[] findAllRoles() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPPrincipal[] findAllPrincipals() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup addGroup(SOAPGroup var1) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException;

    public void updateGroup(String var1, String var2, boolean var3) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public SOAPGroup findGroupByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPGroup findGroupWithAttributesByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPRole addRole(SOAPRole var1) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException;

    public SOAPRole findRoleByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal findPrincipalByToken(String var1) throws RemoteException, InvalidTokenException, InvalidAuthorizationTokenException;

    public void updatePrincipalAttribute(String var1, SOAPAttribute var2) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public void updateGroupAttribute(String var1, SOAPAttribute var2) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public SOAPPrincipal findPrincipalByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal findPrincipalWithAttributesByName(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal addPrincipal(SOAPPrincipal var1, PasswordCredential var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, InvalidUserException, ApplicationPermissionException;

    public void addAllPrincipals(Collection<SOAPPrincipalWithCredential> var1) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, BulkAddFailedException;

    public void addPrincipalToGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void updatePrincipalCredential(String var1, PasswordCredential var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException;

    public void resetPrincipalCredential(String var1) throws RemoteException, InvalidEmailAddressException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException;

    public void removeGroup(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeRole(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipal(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addPrincipalToRole(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public boolean isGroupMember(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException;

    public boolean isRoleMember(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException;

    public void removePrincipalFromGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipalFromRole(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addAttributeToPrincipal(String var1, SOAPAttribute var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeAttributeFromPrincipal(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addAttributeToGroup(String var1, SOAPAttribute var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeAttributeFromGroup(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public long getCacheTime() throws RemoteException, InvalidAuthorizationTokenException;

    public boolean isCacheEnabled() throws RemoteException, InvalidAuthorizationTokenException;

    public String getDomain() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllPrincipalNames() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPNestableGroup[] findAllGroupRelationships() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllRoleNames() throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findGroupMemberships(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public String[] findRoleMemberships(String var1) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public String authenticatePrincipalSimple(String var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public String createPrincipalToken(String var1, ValidationFactor[] var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException;

    public String[] getGrantedAuthorities() throws InvalidAuthorizationTokenException, RemoteException;

    public SOAPCookieInfo getCookieInfo() throws RemoteException, InvalidAuthorizationTokenException;

    public ClientProperties getClientProperties();
}

