package com.atlassian.crowd.common.util;

import java.io.File;

/**
 * A tool for providing the location for imported files, for example for the CSV importer.
 */
public final class ImportsUtil {

    private ImportsUtil() {
    }

    /**
     * @param sharedHomeLocation the shared Crowd home
     * @return the import location
     */
    public static File getImportsLocation(String sharedHomeLocation) {
        return getImportsLocation(new File(sharedHomeLocation));
    }

    /**
     * @param sharedHomeLocation the shared Crowd home
     * @return the import location
     */
    public static File getImportsLocation(File sharedHomeLocation) {
        return new File(sharedHomeLocation, "import");
    }
}
