package com.atlassian.crowd.model.sso;

import java.util.Objects;

/**
 * Represents SAML configuration
 *
 * @since 3.4.0
 */
public class SamlConfiguration {
    private final String issuer;
    private final String ssoUrl;

    public SamlConfiguration(String issuer, String ssoUrl) {
        this.issuer = issuer;
        this.ssoUrl = ssoUrl;
    }

    public String getIssuer() {
        return issuer;
    }

    public String getSsoUrl() {
        return ssoUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SamlConfiguration that = (SamlConfiguration) o;
        return Objects.equals(issuer, that.issuer) &&
                Objects.equals(ssoUrl, that.ssoUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(issuer, ssoUrl);
    }
}
