package com.atlassian.crowd.directory.monitor.poller;

import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;

import java.io.Serializable;
import java.util.Map;

import static com.atlassian.crowd.directory.SyncScheduleType.POLLING_INTERVAL;
import static com.atlassian.crowd.directory.SynchronisableDirectoryProperties.CACHE_SYNCHRONISATION_TYPE;
import static com.atlassian.crowd.directory.SynchronisableDirectoryProperties.CACHE_SYNCHRONISE_CRON;
import static com.atlassian.crowd.directory.monitor.poller.DirectoryPoller.DEFAULT_CACHE_SYNCHRONISE_INTERVAL;

/**
 * Model class holding config of cached directory polling.
 */
public class PollerConfig implements Serializable {
    private static final long serialVersionUID = 569229678073217022L;

    private String cronExpression = "0 0 * ? * *";
    private String synchronisationType = POLLING_INTERVAL;
    private long pollingIntervalInMin = DEFAULT_CACHE_SYNCHRONISE_INTERVAL / 60;

    /**
     * Populates {@link PollerConfig} with data from {@link com.atlassian.crowd.embedded.api.Directory} attributes.
     */
    public void copyFrom(Map<String, String> attributes) {
        final String cacheSynchroniseInterval = attributes.get(SynchronisableDirectoryProperties.CACHE_SYNCHRONISE_INTERVAL);

        cronExpression = attributes.get(CACHE_SYNCHRONISE_CRON);
        synchronisationType = attributes.get(CACHE_SYNCHRONISATION_TYPE);
        pollingIntervalInMin = cacheSynchroniseInterval == null ? 0 : Long.parseLong(cacheSynchroniseInterval) / 60;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getSynchronisationType() {
        return synchronisationType;
    }

    public void setSynchronisationType(String synchronisationType) {
        this.synchronisationType = synchronisationType;
    }

    public long getPollingIntervalInMin() {
        return pollingIntervalInMin;
    }

    public void setPollingIntervalInMin(long pollingIntervalInMin) {
        this.pollingIntervalInMin = pollingIntervalInMin;
    }

    /**
     * Copies {@link PollerConfig} into map of {@link com.atlassian.crowd.embedded.api.Directory} attributes. The attributes
     * map must be mutable.
     */
    public void copyTo(Map<String, String> attributes) {
        // convert pollingInterval to seconds to store in database
        attributes.put(SynchronisableDirectoryProperties.CACHE_SYNCHRONISE_INTERVAL, Long.toString(pollingIntervalInMin * 60));
        attributes.put(SynchronisableDirectoryProperties.CACHE_SYNCHRONISE_CRON, cronExpression);
        attributes.put(SynchronisableDirectoryProperties.CACHE_SYNCHRONISATION_TYPE, synchronisationType);
    }
}
