package com.atlassian.crowd.model.sso;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;

/**
 * Represent pair of private key and x509 certificate
 *
 * @since 3.4.0
 */
public class KeyCertificatePair {
    private final PrivateKey privateKey;
    private final X509Certificate certificate;

    public KeyCertificatePair(PrivateKey privateKey, X509Certificate certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    public PrivateKey getPrivateKey() {
        return privateKey;
    }

    public X509Certificate getCertificate() {
        return certificate;
    }
}
