package com.atlassian.crowd.manager.avatar;

import java.net.URI;

import javax.annotation.Nullable;

import com.atlassian.crowd.model.user.User;

public interface AvatarProvider {
    public static final AvatarProvider NULL_PROVIDER = new AvatarProvider() {
        @Override
        @Nullable
        public URI getUserAvatar(User user, int sizeHint) {
            return null;
        }

        @Override
        @Nullable
        public URI getHostedUserAvatarUrl(long applicationId, String username, int sizeHint) {
            return null;
        }
    };

    /**
     * Gets a URL for an avatar based on the information in this <code>User</code>, if one is available. This may
     * consider the email address or some other property, as opposed to an avatar provided by a remote directory. This
     * may point back to the same Crowd server or to another service. The URI should be evaluated relative to Crowd's
     * base URL.
     *
     * @param user     the user to fetch an avatar for, as returned from a <code>find</code> method
     * @param sizeHint a hint in pixels for how large the image should be
     */
    @Nullable
    URI getUserAvatar(User user, int sizeHint);


    /**
     * Gets a URL for a Crowd-hosted avatar, identified by name, and specific to an application. The avatar
     * will be based on that application's directory mappings and may come from the underlying directory,
     * rather than being derived from the details of a User object.
     */
    @Nullable
    URI getHostedUserAvatarUrl(long applicationId, String username, int sizeHint);
}
