package com.atlassian.crowd.audit.query;

import com.atlassian.annotations.Internal;
import com.google.common.base.MoreObjects;

import java.util.Objects;

@Internal
public class AbstractAuditLogQueryRestriction {
    protected final Long id;
    protected final String name;
    protected final String namePrefix;

    public AbstractAuditLogQueryRestriction(String name, Long id, String namePrefix) {
        this.name = name;
        this.id = id;
        this.namePrefix = namePrefix;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getNamePrefix() {
        return namePrefix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuditLogQueryEntityRestriction that = (AuditLogQueryEntityRestriction) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                Objects.equals(namePrefix, that.namePrefix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, namePrefix);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("name", name)
                .add("namePrefix", namePrefix)
                .toString();
    }
}