package com.atlassian.crowd.model.sso;

/**
 * Represents SAML SSO configuration for an application, without application data
 * @since 3.4.0
 */
public interface BaseApplicationSamlConfiguration {
    /**
     * @return the audience that will be used when creating assertions for the application
     */
    String getAudienceUrl();

    /**
     * @return the URL to which the assertion should be returned
     */
    String getAssertionConsumerUrl();
}
