package com.atlassian.crowd.model.backup;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

import java.util.Objects;

public class BackupConfiguration {
    private int backupTimeHour;
    private int backupTimeMinute;
    private Boolean resetDomainEnabled;
    private Boolean backupConnectorEnabled;
    private Boolean scheduledBackupEnabled;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    protected BackupConfiguration(int backupTimeHour, int backupTimeMinute, Boolean resetDomainEnabled, Boolean backupConnectorEnabled, Boolean scheduledBackupEnabled) {
        Preconditions.checkArgument(backupTimeHour >= 0 && backupTimeHour <= 23, "Backup hour should be between 0 and 23");
        Preconditions.checkArgument(backupTimeMinute >= 0 && backupTimeMinute <= 59, "Backup hour should be between 0 and 59");
        this.backupTimeHour = backupTimeHour;
        this.backupTimeMinute = backupTimeMinute;
        this.resetDomainEnabled = Objects.requireNonNull(resetDomainEnabled);
        this.backupConnectorEnabled = Objects.requireNonNull(backupConnectorEnabled);
        this.scheduledBackupEnabled = Objects.requireNonNull(scheduledBackupEnabled);
    }

    public int getBackupTimeHour() {
        return backupTimeHour;
    }

    public void setBackupTimeHour(int backupTimeHour) {
        this.backupTimeHour = backupTimeHour;
    }

    public int getBackupTimeMinute() {
        return backupTimeMinute;
    }

    public void setBackupTimeMinute(int backupTimeMinute) {
        this.backupTimeMinute = backupTimeMinute;
    }

    public Boolean isResetDomainEnabled() {
        return resetDomainEnabled;
    }

    public void setResetDomainEnabled(Boolean resetDomainEnabled) {
        this.resetDomainEnabled = Objects.requireNonNull(resetDomainEnabled);
    }

    public Boolean isBackupConnectorEnabled() {
        return backupConnectorEnabled;
    }

    public void setBackupConnectorEnabled(Boolean backupConnectorEnabled) {
        this.backupConnectorEnabled = Objects.requireNonNull(backupConnectorEnabled);
    }

    public Boolean isScheduledBackupEnabled() {
        return scheduledBackupEnabled;
    }

    public void setScheduledBackupEnabled(Boolean scheduledBackupEnabled) {
        this.scheduledBackupEnabled = Objects.requireNonNull(scheduledBackupEnabled);
    }

    public static BackupConfiguration.Builder builder() {
        return new BackupConfiguration.Builder();
    }

    public static BackupConfiguration.Builder builder(BackupConfiguration data) {
        return new BackupConfiguration.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BackupConfiguration that = (BackupConfiguration) o;

        return Objects.equals(this.getBackupTimeHour(), that.getBackupTimeHour()) && Objects.equals(this.getBackupTimeMinute(), that.getBackupTimeMinute()) && Objects.equals(this.isResetDomainEnabled(), that.isResetDomainEnabled()) && Objects.equals(this.isBackupConnectorEnabled(), that.isBackupConnectorEnabled()) && Objects.equals(this.isScheduledBackupEnabled(), that.isScheduledBackupEnabled());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getBackupTimeHour(), getBackupTimeMinute(), isResetDomainEnabled(), isBackupConnectorEnabled(), isScheduledBackupEnabled());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("backupTimeHour", getBackupTimeHour())
                .add("backupTimeMinute", getBackupTimeMinute())
                .add("resetDomainEnabled", isResetDomainEnabled())
                .add("backupConnectorEnabled", isBackupConnectorEnabled())
                .add("scheduledBackupEnabled", isScheduledBackupEnabled())
                .toString();
    }

    public static final class Builder {

        private int backupTimeHour;
        private int backupTimeMinute;
        private Boolean resetDomainEnabled;
        private Boolean backupConnectorEnabled;
        private Boolean scheduledBackupEnabled;

        private Builder() {
        }

        private Builder(BackupConfiguration initialData) {
            this.backupTimeHour = initialData.getBackupTimeHour();
            this.backupTimeMinute = initialData.getBackupTimeMinute();
            this.resetDomainEnabled = initialData.isResetDomainEnabled();
            this.backupConnectorEnabled = initialData.isBackupConnectorEnabled();
            this.scheduledBackupEnabled = initialData.isScheduledBackupEnabled();
        }

        public Builder setBackupTimeHour(int backupTimeHour) {
            this.backupTimeHour = backupTimeHour;
            return this;
        }

        public Builder setBackupTimeMinute(int backupTimeMinute) {
            this.backupTimeMinute = backupTimeMinute;
            return this;
        }

        public Builder setResetDomainEnabled(Boolean resetDomainEnabled) {
            this.resetDomainEnabled = resetDomainEnabled;
            return this;
        }

        public Builder setBackupConnectorEnabled(Boolean backupConnectorEnabled) {
            this.backupConnectorEnabled = backupConnectorEnabled;
            return this;
        }

        public Builder setScheduledBackupEnabled(Boolean scheduledBackupEnabled) {
            this.scheduledBackupEnabled = scheduledBackupEnabled;
            return this;
        }

        public BackupConfiguration build() {
            return new BackupConfiguration(backupTimeHour, backupTimeMinute, resetDomainEnabled, backupConnectorEnabled, scheduledBackupEnabled);
        }
    }
}
