package com.atlassian.crowd.manager.permission;


/**
 * A representation of a per-directory group
 */
public interface DirectoryGroup {
    /**
     * ID of the directory this group belongs to
     *
     * @return the directory id
     */
    Long getDirectoryId();

    /**
     * Convenience method - the name of the directory this group belongs to
     *
     * @return the directory name
     */
    String getDirectoryName();

    /**
     * The name of this group
     *
     * @return the group name
     */
    String getGroupName();
}
