package com.atlassian.crowd.directory;

import com.atlassian.crowd.exception.OperationFailedException;

/**
 * Interface to be implemented by directory implementations that can compute counts fast.
 */
public interface FastEntityCountProvider {
    /**
     * @return number of users found in this directory.
     * @throws OperationFailedException underlying directory implementation failed to execute the operation.
     */
    long getUserCount() throws OperationFailedException;

    /**
     * @return number of groups found in this directory.
     * @throws OperationFailedException underlying directory implementation failed to execute the operation.
     */
    long getGroupCount() throws OperationFailedException;
}
