package com.atlassian.crowd.audit.query;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Allows specifying a projection for an {@link AuditLogQuery}.
 * When a projection is specified only some fields of the query results will be populated.
 * @since 3.2
 */
@ExperimentalApi
public enum AuditLogChangesetProjection {
    /**
     * Only populates the event type of the changesets
     */
    EVENT_TYPE,
    /**
     * Only populates the author of the changesets
     */
    AUTHOR,
    /**
     * Only populates changeset entities that are users
     */
    ENTITY_USER,
    /**
     * Only populates changeset entities that are groups
     */
    ENTITY_GROUP,
    /**
     * Only populates changeset entities that are applications
     */
    ENTITY_APPLICATION,
    /**
     * Only populates changeset entities that are directories
     */
    ENTITY_DIRECTORY,
    /**
     * Only populates the source of the changesets
     */
    SOURCE
}