package com.atlassian.crowd.search.query.membership;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;

import static com.atlassian.crowd.search.query.QueryUtils.checkAssignableFrom;

public class UserMembershipQuery<T> extends MembershipQuery<T> {
    /**
     * @deprecated Use {@link #UserMembershipQuery(Class, boolean, EntityDescriptor, EntityDescriptor, int, int, SearchRestriction, String...)} instead. Since v2.9.
     */
    @Deprecated
    public UserMembershipQuery(Class<T> returnType, boolean findMembers, EntityDescriptor entityToMatch, String entityNameToMatch, EntityDescriptor entityToReturn, int startIndex, int maxResults) {
        this(returnType, findMembers, entityToMatch, entityToReturn, startIndex, maxResults, QueryBuilder.NULL_RESTRICTION, entityNameToMatch);
    }

    public UserMembershipQuery(final Class<T> returnType, final boolean findMembers, final EntityDescriptor entityToMatch, final EntityDescriptor entityToReturn, final int startIndex, final int maxResults, final SearchRestriction searchRestriction, final String... entityNamesToMatch) {
        super(checkAssignableFrom(returnType, String.class, User.class), findMembers, entityToMatch, entityToReturn, startIndex, maxResults, searchRestriction, entityNamesToMatch);
    }
}
