/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.token;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class Token
implements Serializable {
    public static final long APPLICATION_TOKEN_DIRECTORY_ID = -1L;
    private Long id;
    private String identifierHash;
    private String randomHash;
    private long randomNumber;
    private Date createdDate;
    private Date lastAccessedDate;
    private String name;
    private long directoryId = -1L;

    public Token(long directoryId, String name, String identifierHash, long randomNumber, String randomHash) {
        this(directoryId, name, identifierHash, randomNumber, randomHash, new Date(), new Date());
    }

    protected Token(long directoryId, String name, String identifierHash, long randomNumber, String randomHash, Date createdDate, Date lastAccessedDate) {
        Validate.notNull((Object)directoryId, (String)"directoryId argument cannot be null");
        this.directoryId = directoryId;
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        this.name = name;
        Validate.notNull((Object)identifierHash, (String)"identifierHash argument cannot be null");
        this.identifierHash = identifierHash;
        Validate.notNull((Object)randomNumber, (String)"randomNumber argument cannot be null");
        this.randomNumber = randomNumber;
        Validate.notNull((Object)randomHash, (String)"randomHash argument cannot be null");
        this.randomHash = randomHash;
        Validate.notNull((Object)createdDate, (String)"createdDate argument cannot be null");
        this.createdDate = createdDate;
        Validate.notNull((Object)lastAccessedDate, (String)"lastAccessedDate argument cannot be null");
        this.lastAccessedDate = lastAccessedDate;
    }

    private Token() {
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public String getRandomHash() {
        return this.randomHash;
    }

    private void setRandomHash(String randomHash) {
        this.randomHash = randomHash;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    private void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    public long getRandomNumber() {
        return this.randomNumber;
    }

    private void setRandomNumber(long randomNumber) {
        this.randomNumber = randomNumber;
    }

    public boolean isUserToken() {
        return !this.isApplicationToken();
    }

    public boolean isApplicationToken() {
        return this.getDirectoryId() == -1L;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    private void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getLastAccessedDate() {
        return this.lastAccessedDate;
    }

    protected void setLastAccessedDate(Date lastAccessedDate) {
        this.lastAccessedDate = lastAccessedDate;
    }

    public String getIdentifierHash() {
        return this.identifierHash;
    }

    private void setIdentifierHash(String identifierHash) {
        this.identifierHash = identifierHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return !(this.getIdentifierHash() != null ? !this.getIdentifierHash().equals(token.getIdentifierHash()) : token.getIdentifierHash() != null);
    }

    public int hashCode() {
        return this.getIdentifierHash() != null ? this.getIdentifierHash().hashCode() : 0;
    }
}

