/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.util.RemoteAddressHelper;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteAddress
implements Serializable,
Comparable<RemoteAddress> {
    private String address;
    private String binaryAddress;

    protected RemoteAddress() {
    }

    public RemoteAddress(String address) {
        Validate.notNull((Object)address, (String)"You cannot create a remote address with null address");
        this.address = address.toLowerCase().trim();
        if (RemoteAddressHelper.isCidrNotation(address)) {
            this.binaryAddress = RemoteAddressHelper.maskedAddressInBinary(address);
        } else if (RemoteAddressHelper.isIpAddressNotation(address)) {
            this.binaryAddress = RemoteAddressHelper.addressInBinary(address);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getBinaryAddress() {
        return this.binaryAddress;
    }

    private void setAddress(String address) {
        this.address = address;
    }

    private void setBinaryAddress(String binaryAddress) {
        this.binaryAddress = binaryAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteAddress that = (RemoteAddress)o;
        return !(this.address != null ? !this.address.equals(that.address) : that.address != null);
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    @Override
    public int compareTo(RemoteAddress o) {
        return this.address.compareTo(o.getAddress());
    }
}

