/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.BulkAddFailedException;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ApplicationService {
    public List<Application> findAuthorisedApplications(User var1) throws ObjectNotFoundException, DirectoryAccessException;

    public Token authenticateApplication(ApplicationAuthenticationContext var1) throws InvalidAuthenticationException;

    public Token authenticateUser(UserAuthenticationContext var1) throws InvalidAuthenticationException, DirectoryAccessException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public Token authenticateUserWithoutValidatingPassword(UserAuthenticationContext var1) throws InvalidAuthenticationException, DirectoryAccessException, InactiveAccountException, ApplicationAccessDeniedException;

    public Token validateApplicationToken(String var1, ValidationFactor[] var2) throws InvalidTokenException;

    public Token validateUserToken(String var1, ValidationFactor[] var2, String var3) throws InvalidTokenException, ApplicationAccessDeniedException, DirectoryAccessException;

    public User findUserByName(Application var1, String var2) throws ObjectNotFoundException, DirectoryAccessException;

    public UserWithAttributes findUserWithAttributesByName(Application var1, String var2) throws ObjectNotFoundException, DirectoryAccessException;

    public User addUser(Application var1, UserTemplate var2, PasswordCredential var3) throws InvalidUserException, DirectoryAccessException, InvalidCredentialException, ApplicationPermissionException;

    public void addAllUsers(Application var1, Collection<UserTemplateWithCredentialAndAttributes> var2) throws ApplicationPermissionException, RemoteException, DirectoryAccessException, BulkAddFailedException;

    public User updateUser(Application var1, UserTemplate var2) throws InvalidUserException, DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException;

    public void updateUserCredential(Application var1, String var2, PasswordCredential var3) throws DirectoryAccessException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException;

    public void resetUserCredential(Application var1, String var2) throws DirectoryAccessException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException;

    public void storeUserAttributes(Application var1, String var2, Map<String, List<String>> var3) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException;

    public void removeUserAttributes(Application var1, String var2, String var3) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException;

    public void removeUser(Application var1, String var2) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException;

    public List searchUsers(Application var1, EntityQuery var2) throws DirectoryAccessException;

    public Group findGroupByName(Application var1, String var2) throws ObjectNotFoundException, DirectoryAccessException;

    public GroupWithAttributes findGroupWithAttributesByName(Application var1, String var2) throws ObjectNotFoundException, DirectoryAccessException;

    public Group addGroup(Application var1, GroupTemplate var2) throws InvalidGroupException, DirectoryAccessException, ApplicationPermissionException;

    public Group updateGroup(Application var1, GroupTemplate var2) throws InvalidGroupException, DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException;

    public void storeGroupAttributes(Application var1, String var2, Map<String, List<String>> var3) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException;

    public void removeGroupAttributes(Application var1, String var2, String var3) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException;

    public void removeGroup(Application var1, String var2) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException;

    public List searchGroups(Application var1, EntityQuery var2) throws DirectoryAccessException;

    public void addUserToGroup(Application var1, String var2, String var3) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException;

    public void addGroupToGroup(Application var1, String var2, String var3) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeUserFromGroup(Application var1, String var2, String var3) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException, MembershipNotFoundException;

    public void removeGroupFromGroup(Application var1, String var2, String var3) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException, MembershipNotFoundException;

    public boolean isUserDirectGroupMember(Application var1, String var2, String var3) throws DirectoryAccessException;

    public boolean isGroupDirectGroupMember(Application var1, String var2, String var3) throws DirectoryAccessException;

    public boolean isUserNestedGroupMember(Application var1, String var2, String var3) throws DirectoryAccessException;

    public boolean isGroupNestedGroupMember(Application var1, String var2, String var3) throws DirectoryAccessException;

    public List searchDirectGroupRelationships(Application var1, MembershipQuery var2) throws DirectoryAccessException;

    public List searchNestedGroupRelationships(Application var1, MembershipQuery var2) throws DirectoryAccessException;
}

