/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.user;

import com.atlassian.crowd.integration.model.user.User;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class UserTemplate
implements User,
Serializable {
    private Long directoryId;
    private String name;
    private boolean active;
    private String emailAddress;
    private String firstName;
    private String lastName;
    private String displayName;
    private String iconLocation;

    public UserTemplate(String username, Long directoryId) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)username), (String)"username argument cannot be null or blank");
        this.name = username;
        this.directoryId = directoryId;
    }

    public UserTemplate(String name) {
        this(name, null);
    }

    public UserTemplate(User user) {
        Validate.notNull((Object)user, (String)"user argument cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)user.getName()), (String)"user.name argument cannot be null or blank");
        this.name = user.getName();
        this.directoryId = user.getDirectoryId();
        this.active = user.isActive();
        this.emailAddress = user.getEmailAddress();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.displayName = user.getDisplayName();
        this.iconLocation = user.getIconLocation();
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public void setIconLocation(String iconLocation) {
        this.iconLocation = iconLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserTemplate)) {
            return false;
        }
        UserTemplate that = (UserTemplate)o;
        if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.directoryId != null ? this.directoryId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("directoryId", (Object)this.directoryId).append("active", this.active).append("emailAddress", (Object)this.emailAddress).append("firstName", (Object)this.firstName).append("lastName", (Object)this.lastName).append("displayName", (Object)this.displayName).append("iconLocation", (Object)this.iconLocation).toString();
    }
}

