/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.integration.directory.monitor.MonitorCapable;
import com.atlassian.crowd.integration.directory.monitor.listener.ListeningCapable;
import com.atlassian.crowd.integration.directory.monitor.poller.PollingCapable;
import com.atlassian.crowd.integration.model.AttributeValues;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryAttributesHelper {
    public static boolean isUseCaching(Map<String, AttributeValues> attributes) {
        return DirectoryAttributesHelper.getAttributeBooleanValue("useCaching", attributes);
    }

    public static boolean isUseMonitoring(Map<String, AttributeValues> attributes) {
        return DirectoryAttributesHelper.getAttributeBooleanValue("useMonitoring", attributes);
    }

    public static String getCacheClass(Map<String, AttributeValues> attributes) {
        String className = DirectoryAttributesHelper.getAttributeStringValue("cacheClass", attributes);
        return className == null ? null : className.trim();
    }

    public static long getPollingInterval(Map<String, AttributeValues> attributes) {
        return DirectoryAttributesHelper.getAttributeLongValue("pollingInterval", attributes);
    }

    public static long getMaxCacheElementsInMemory(Map<String, AttributeValues> attributes) {
        return DirectoryAttributesHelper.getAttributeLongValue("cacheMaxElements", attributes);
    }

    protected static long getAttributeLongValue(String key, Map<String, AttributeValues> attributes) {
        String value = DirectoryAttributesHelper.getAttributeStringValue(key, attributes);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean getAttributeBooleanValue(String key, Map<String, AttributeValues> attributes) {
        String flag = DirectoryAttributesHelper.getAttributeStringValue(key, attributes);
        if (flag == null) {
            return false;
        }
        return flag.toLowerCase().equals("true");
    }

    protected static String getAttributeStringValue(String key, Map<String, AttributeValues> attributes) {
        AttributeValues attributeValues = attributes.get(key);
        String value = null;
        if (attributeValues != null && attributeValues.getValues() != null && attributeValues.getValues().size() > 0) {
            value = attributeValues.getValues().get(0);
        }
        return value;
    }

    protected static boolean isAssignableFrom(Class parentClass, String className) {
        try {
            Class connectorClass = ClassLoaderUtils.loadClass((String)className, DirectoryAttributesHelper.class);
            return parentClass.isAssignableFrom(connectorClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMonitorCapable(String connectorClassName) {
        return DirectoryAttributesHelper.isAssignableFrom(MonitorCapable.class, connectorClassName);
    }

    public static boolean isPollingCapable(String connectorClassName) {
        return DirectoryAttributesHelper.isAssignableFrom(PollingCapable.class, connectorClassName);
    }

    public static boolean isListeningCapable(String connectorClassName) {
        return DirectoryAttributesHelper.isAssignableFrom(ListeningCapable.class, connectorClassName);
    }
}

