/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.permission;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PermissionType {
    ADD_PRINCIPAL("principal.add"),
    ADD_ROLE("role.add"),
    ADD_GROUP("group.add"),
    REMOVE_PRINCIPAL("principal.remove"),
    REMOVE_ROLE("role.remove"),
    REMOVE_GROUP("group.remove"),
    MODIFY_PRINCIPAL("principal.modify"),
    MODIFY_ROLE("role.modify"),
    MODIFY_GROUP("group.modify");

    private final String name;

    private PermissionType(String permissionName) {
        this.name = permissionName;
    }

    public String getName() {
        return this.name;
    }

    public static List getPermissionTypes() {
        return Arrays.asList(ADD_PRINCIPAL, ADD_ROLE, ADD_GROUP, MODIFY_PRINCIPAL, MODIFY_ROLE, MODIFY_GROUP, REMOVE_PRINCIPAL, REMOVE_ROLE, REMOVE_GROUP);
    }

    public static PermissionType fromName(String name) {
        PermissionType type = null;
        if ("principal.add".equals(name)) {
            type = ADD_PRINCIPAL;
        } else if ("role.add".equals(name)) {
            type = ADD_ROLE;
        } else if ("group.add".equals(name)) {
            type = ADD_GROUP;
        } else if ("principal.remove".equals(name)) {
            type = REMOVE_PRINCIPAL;
        } else if ("role.remove".equals(name)) {
            type = REMOVE_ROLE;
        } else if ("group.remove".equals(name)) {
            type = REMOVE_GROUP;
        } else if ("principal.modify".equals(name)) {
            type = MODIFY_PRINCIPAL;
        } else if ("role.modify".equals(name)) {
            type = MODIFY_ROLE;
        } else if ("group.modify".equals(name)) {
            type = MODIFY_GROUP;
        }
        return type;
    }
}

