/**
 * @module confluence-templates/variable-toolbar
 */
define('confluence-templates/variable-toolbar', [
    'ajs',
    'document',
    'confluence/api/event',
    'jquery',
    'confluence/legacy'
], function(
    AJS,
    document,
    event,
    $,
    Confluence
) {
    'use strict';

    return {
        init: function() {
            event.bind('init.rte', function() {
                var variableManager = Confluence.VariableManager.defaultVariableManager;
                var menu = $('#template-menu');
                var variableList = menu.find('.variables-list');

                event.bind('add.confluence-variable,delete.confluence-variable,rename.confluence-variable', function(e, v) {
                    // Simple implementation - just reload the div
                    var variables = variableManager.getSortedNames();
                    var len = variables.length;
                    var items = '';
                    variableList.toggleClass('hidden', !len);

                    for (var i = 0; i < len; i++) {
                        items += Confluence.Templates.Variables.renderVariableItem({
                            variableName: '$' + variables[i],
                            tooltip: AJS.I18n.getText('tinymce.templates.variables.insert.tooltip', variables[i])
                        });
                    }

                    variableList.html(items);
                });

                menu.delegate('.variables-list a', 'click', function() {
                    var name = $(this).attr('data-variable-name');
                    !variableManager.contains(name) && variableManager.add(name);
                    Confluence.VariablePlaceHolder.insertPlaceholder(name);
                });

                menu.delegate('.variables-add', 'click', function(e) {
                    var inputDrivenDropdown = Confluence.Editor.Autocompleter.Manager.getInputDrivenDropdown();
                    AJS.Rte.getEditor().focus();
                    if (!inputDrivenDropdown || inputDrivenDropdown.inactive) {
                        Confluence.Editor.Autocompleter.Manager.shortcutFired('$', true);
                    }
                    e.stopPropagation();
                });

                $(document).bind('showLayer', function(event, type, dd) {
                    if (type === 'dropdown' && dd.$.closest(menu).length) {
                        // is template menu drop down - reset to ensure hover highlights work
                        dd.reset();
                    }
                });
            });
        }
    };
});

if (AJS.Meta.get('content-type') === 'template') {
    require('confluence/module-exporter').safeRequire('confluence-templates/variable-toolbar', function(VariableToolbar) {
        'use strict';

        VariableToolbar.init();
    });
}
