/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.templates.actions;

import com.atlassian.confluence.core.persistence.confluence.StaleObjectStateException;
import com.atlassian.confluence.plugins.templates.actions.AbstractPageTemplateAction;
import org.apache.commons.lang3.StringUtils;

public class EditPageTemplateDescriptionAction
extends AbstractPageTemplateAction {
    private String newDescription;

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isNotBlank((CharSequence)this.newDescription) && this.newDescription.length() > 255) {
            this.addActionError(this.getText("page.template.description.too.long"));
        }
    }

    public String doEdit() {
        this.getPageTemplate().setDescription(StringUtils.trimToNull((String)this.newDescription));
        try {
            this.pageTemplateManager.savePageTemplate(this.pageTemplate, this.originalPageTemplate);
            return "success" + this.globalTemplateSuffix();
        }
        catch (StaleObjectStateException e) {
            return this.addStaleError((Exception)((Object)e));
        }
    }

    private String addStaleError(Exception e) {
        this.pageTemplateManager.refreshPageTemplate(this.getPageTemplate());
        LOG.debug((Object)"Editing an outdated version of the page!", (Throwable)e);
        this.addActionError(this.getText("editing.an.outdated.emailtemplate.version"));
        return "error";
    }
}

