/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.AlreadyExistsException;
import com.atlassian.confluence.rpc.NotFoundException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.SoapUtils;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceGroup;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SetSpacePermissionChecker;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.service.AnonymousUserPermissionsService;
import com.atlassian.confluence.security.service.IllegalPermissionStateException;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceGroup;
import com.atlassian.confluence.spaces.SpaceGroupManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SpacesSoapService {
    private SpaceManager spaceManager;
    private PermissionManager permissionManager;
    private SpacePermissionManager spacePermissionManager;
    private PersonalInformationManager personalInformationManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private SoapServiceHelper soapServiceHelper;
    private ImportExportManager importExportManager;
    private SettingsManager settingsManager;
    private GateKeeper gateKeeper;
    private UserAccessor userAccessor;
    private SpaceGroupManager spaceGroupManager;
    private PageManager pageManager;
    private SetSpacePermissionChecker setSpacePermissionChecker;
    private AnonymousUserPermissionsService anonymousUserPermissionsService;

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public RemoteSpaceSummary[] getSpaces() throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        List spaces = this.spaceManager.getPermittedSpaces(user);
        return SoapUtils.getSpaceSummaries(spaces);
    }

    public RemoteSpaceSummary[] getSpacesInGroup(String groupKey) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        SpaceGroup spaceGroup = this.spaceGroupManager.getSpaceGroup(groupKey);
        List spaces = this.spaceManager.getPermittedSpacesInSpaceGroup(user, spaceGroup);
        return SoapUtils.getSpaceSummaries(spaces);
    }

    public RemoteSpace getSpace(String spaceKey) throws RemoteException {
        return new RemoteSpace(this.soapServiceHelper.retrieveSpace(spaceKey), this.wikiStyleRenderer);
    }

    public String[] getPermissions(String spaceKey) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        return this.getUserPermissions(space, user);
    }

    public String[] getPermissions(String spaceKey, String userName) throws RemoteException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        User user = this.userAccessor.getUser(userName);
        if (!this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)space) && !currentUser.equals(user)) {
            throw new NotPermittedException("Only space administrators can view permissions for other users in the space.");
        }
        if (userName == null || this.userAccessor.getUser(userName) == null) {
            throw new RemoteException("No user with the name '" + userName + "' exists.");
        }
        return this.getUserPermissions(space, user);
    }

    private String[] getUserPermissions(Space space, User user) {
        ArrayList<String> permissions = new ArrayList<String>(4);
        if (this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space)) {
            permissions.add("view");
        }
        if (this.permissionManager.hasCreatePermission(user, (Object)space, Page.class)) {
            permissions.add("modify");
        }
        if (this.permissionManager.hasCreatePermission(user, (Object)space, Comment.class)) {
            permissions.add("comment");
        }
        if (this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space)) {
            permissions.add("admin");
        }
        return permissions.toArray(new String[permissions.size()]);
    }

    public RemoteSpace addSpace(RemoteSpace space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!Space.isValidGlobalSpaceKey((String)space.getKey())) {
            throw new RemoteException("Invalid space key: " + space.getKey());
        }
        if (!this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, Space.class)) {
            throw new NotPermittedException("No permission to create spaces.");
        }
        if (this.spaceManager.getSpace(space.getKey()) != null) {
            throw new AlreadyExistsException("A space already exists with key " + space.getKey());
        }
        Space newSpace = this.spaceManager.createSpace(space.getKey(), space.getName(), space.getDescription(), user);
        if (space.getSpaceGroup() != null) {
            SpaceGroup spaceGroup = this.spaceGroupManager.getSpaceGroup(space.getSpaceGroup());
            if (spaceGroup == null) {
                throw new RemoteException("Invalid space group key: " + space.getSpaceGroup());
            }
            newSpace.setSpaceGroup(spaceGroup);
            this.spaceManager.saveSpace(newSpace);
        }
        return new RemoteSpace(newSpace, this.wikiStyleRenderer);
    }

    public RemoteSpace storeSpace(RemoteSpace remoteSpace) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        Space space = this.spaceManager.getSpace(remoteSpace.getKey());
        if (space == null) {
            throw new RemoteException("A space with the key '" + remoteSpace.getKey() + "' doesn't exist. You can not change the space key from an existing space.");
        }
        if (!Space.isValidGlobalSpaceKey((String)space.getKey())) {
            throw new RemoteException("Invalid space key: " + space.getKey());
        }
        if (!this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space)) {
            throw new NotPermittedException("No permission to change the space details.");
        }
        space.setName(remoteSpace.getName());
        space.setHomePage(this.pageManager.getPage(remoteSpace.getHomePage()));
        space.setSpaceGroup(this.spaceGroupManager.getSpaceGroup(remoteSpace.getSpaceGroup()));
        this.spaceManager.saveSpace(space);
        return new RemoteSpace(space, this.wikiStyleRenderer);
    }

    public RemoteSpaceGroup addSpaceGroup(RemoteSpaceGroup spaceGroup) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!Space.isValidGlobalSpaceKey((String)spaceGroup.getKey())) {
            throw new RemoteException("Invalid spaceGroup key: " + spaceGroup.getKey());
        }
        if (!this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, Space.class)) {
            throw new NotPermittedException("No permission to create spacesGroups.");
        }
        if (this.spaceGroupManager.getSpaceGroup(spaceGroup.getKey()) != null) {
            throw new AlreadyExistsException("A spaceGroup already exists with key " + spaceGroup.getKey());
        }
        return new RemoteSpaceGroup(this.spaceGroupManager.createSpaceGroup(spaceGroup.getKey(), spaceGroup.getName()));
    }

    public RemoteSpaceGroup getSpaceGroup(String spaceGroupKey) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        SpaceGroup spaceGroup = this.spaceGroupManager.getSpaceGroup(spaceGroupKey);
        if (spaceGroup == null) {
            throw new RemoteException("SpaceGroup with key \"" + spaceGroupKey + "\" does not exist");
        }
        return new RemoteSpaceGroup(spaceGroup);
    }

    public RemoteSpaceGroup[] getSpaceGroups() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        List spaceGroups = this.spaceGroupManager.getSpaceGroups();
        return SoapUtils.getSpaceGroups(spaceGroups);
    }

    public boolean removeSpaceGroup(String spaceGroupKey) throws RemoteException {
        SpaceGroup spaceGroup = this.spaceGroupManager.getSpaceGroup(spaceGroupKey);
        if (spaceGroup == null) {
            throw new RemoteException("No spaceGroup found for space key: " + spaceGroup);
        }
        this.soapServiceHelper.assertCanAdminister();
        this.spaceGroupManager.removeSpaceGroup(spaceGroup, false);
        return true;
    }

    protected void verifyPersonalSpaceCreation(User user) throws NotPermittedException, AlreadyExistsException {
        PersonalInformation pi;
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasCreatePermission(currentUser, (Object)(pi = this.personalInformationManager.getPersonalInformation(user)), Space.class)) {
            throw new NotPermittedException("No permission to create spaces.");
        }
        if (currentUser != null && !user.getName().equals(currentUser.getName()) && !this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new NotPermittedException("No permission to create a personal space for user " + user.getName());
        }
        if (this.spaceManager.getSpace("~" + user.getName()) != null) {
            throw new AlreadyExistsException("A space already exists with key ~" + user.getName());
        }
    }

    public RemoteSpace addPersonalSpace(RemoteSpace space, String username) throws RemoteException {
        User user = this.userAccessor.getUser(username);
        if (user == null) {
            throw new RemoteException("No user found with name " + username);
        }
        this.verifyPersonalSpaceCreation(user);
        return new RemoteSpace(this.spaceManager.createPersonalSpace(space.getName(), space.getDescription(), user), this.wikiStyleRenderer);
    }

    @Deprecated
    public boolean convertToPersonalSpace(String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException {
        User targetUser = this.userAccessor.getUser(userName);
        if (targetUser == null) {
            throw new RemoteException("No user found with name " + userName);
        }
        this.verifyPersonalSpaceCreation(targetUser);
        Space targetSpace = this.spaceManager.getSpace(spaceKey);
        if (targetSpace == null) {
            throw new RemoteException("Space '" + spaceKey + "' does not exist");
        }
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)targetSpace)) {
            throw new NotPermittedException("You are not permitted to convert the space'" + spaceKey + "' to a personal space");
        }
        this.spaceManager.convertToPersonalSpace(targetSpace, targetUser, updateLinks);
        if (StringUtils.isNotBlank((String)newName)) {
            Space personalSpace = this.spaceManager.getPersonalSpace(userName);
            personalSpace.setName(newName);
            this.spaceManager.saveSpace(personalSpace);
        }
        return true;
    }

    public String[] getSpaceLevelPermissions() throws RemoteException {
        Collection genericPermissions = SpacePermission.GENERIC_SPACE_PERMISSIONS;
        String[] permissions = new String[genericPermissions.size() + 1];
        Iterator it = genericPermissions.iterator();
        int i = 0;
        while (it.hasNext()) {
            permissions[i] = (String)it.next();
            ++i;
        }
        permissions[permissions.length - 1] = "VIEWSPACE";
        return permissions;
    }

    public boolean addPermissionToSpace(String permission, String remoteEntityName, String spaceKey) throws RemoteException {
        if (permission == null) {
            throw new RemoteException("Space Permission must be non-null");
        }
        String[] permissionsArray = new String[]{permission};
        return this.addPermissionsToSpace(permissionsArray, remoteEntityName, spaceKey);
    }

    public boolean addGlobalPermissions(String[] permissions, String remoteEntityName) throws RemoteException {
        if (permissions == null) {
            throw new RemoteException("Permissions must be non-null");
        }
        this.soapServiceHelper.assertCanAdminister();
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            this.addGlobalPermission(permission, remoteEntityName);
        }
        return true;
    }

    public boolean addGlobalPermission(String permission, String remoteEntityName) throws RemoteException {
        if (permission == null) {
            throw new RemoteException("Permission must be non-null");
        }
        this.soapServiceHelper.assertCanAdminister();
        UserOrGroupResolver resolver = new UserOrGroupResolver(remoteEntityName);
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        SpacePermission newPermission = new SpacePermission(permission, null, resolver.getGroupName(), resolver.getUserName());
        if (!globalPermissions.contains(newPermission)) {
            globalPermissions.add(newPermission);
            this.spacePermissionManager.savePermission(newPermission);
        }
        return true;
    }

    public boolean addAnonymousUsePermission() throws RemoteException {
        try {
            this.anonymousUserPermissionsService.setUsePermission(true);
        }
        catch (NotAuthorizedException ex) {
            throw new RemoteException((Throwable)ex);
        }
        return true;
    }

    public boolean removeAnonymousUserPermission() throws RemoteException {
        try {
            this.anonymousUserPermissionsService.setUsePermission(false);
        }
        catch (NotAuthorizedException ex) {
            throw new RemoteException((Throwable)ex);
        }
        return true;
    }

    public boolean addAnonymousViewUserProfilePermission() throws RemoteException {
        try {
            this.anonymousUserPermissionsService.setViewUserProfilesPermission(true);
        }
        catch (NotAuthorizedException ex) {
            throw new RemoteException((Throwable)ex);
        }
        catch (IllegalPermissionStateException ex) {
            return false;
        }
        return true;
    }

    public boolean removeAnonymousViewUserProfilePermission() throws RemoteException {
        try {
            this.anonymousUserPermissionsService.setViewUserProfilesPermission(false);
        }
        catch (NotAuthorizedException ex) {
            throw new RemoteException((Throwable)ex);
        }
        return true;
    }

    public boolean removeGlobalPermission(String permission, String remoteEntityName) throws NotPermittedException, RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        UserOrGroupResolver resolver = new UserOrGroupResolver(remoteEntityName);
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        SpacePermission permissionToBeRemoved = new SpacePermission(permission, null, resolver.getGroupName(), resolver.getUserName());
        for (int i = 0; i < globalPermissions.size(); ++i) {
            SpacePermission globalPermission = (SpacePermission)globalPermissions.get(i);
            if (!permissionToBeRemoved.equals((Object)globalPermission)) continue;
            if (this.setSpacePermissionChecker.canSetPermission(AuthenticatedUserThreadLocal.getUser(), globalPermission)) {
                this.spacePermissionManager.removePermission(globalPermission);
                continue;
            }
            throw new NotPermittedException("You do not have permission to remove " + permission + " from " + remoteEntityName);
        }
        return true;
    }

    private Space validatePermissionsOperation(String spaceKey) throws RemoteException {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new NotFoundException("Cannot modify space permissions: space with key '" + spaceKey + "' not found");
        }
        this.soapServiceHelper.assertCanAdminister(space);
        return space;
    }

    public boolean addPermissionsToSpace(String[] permissions, String remoteEntityName, String spaceKey) throws RemoteException, NotPermittedException {
        if (permissions == null) {
            throw new RemoteException("Space Permissions must be non-null");
        }
        Space space = this.validatePermissionsOperation(spaceKey);
        UserOrGroupResolver resolver = new UserOrGroupResolver(remoteEntityName);
        List spacePermissions = space.getPermissions();
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            SpacePermission userPermission = new SpacePermission(permission, space, resolver.getGroupName(), resolver.getUserName());
            if (spacePermissions.contains(userPermission)) continue;
            space.addPermission(userPermission);
            this.spacePermissionManager.savePermission(userPermission);
        }
        return true;
    }

    public boolean removePermissionFromSpace(String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException {
        Space space = this.validatePermissionsOperation(spaceKey);
        UserOrGroupResolver resolver = new UserOrGroupResolver(remoteEntityName);
        List spacePermissions = space.getPermissions();
        SpacePermission userPermission = new SpacePermission(permission, space, resolver.getGroupName(), resolver.getUserName());
        for (int i = 0; i < spacePermissions.size(); ++i) {
            SpacePermission spacePermission = (SpacePermission)spacePermissions.get(i);
            if (!userPermission.equals((Object)spacePermission)) continue;
            this.spacePermissionManager.removePermission(spacePermission);
        }
        return true;
    }

    public Boolean removeSpace(String spaceKey) throws RemoteException {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new RemoteException("No space found for space key: " + spaceKey);
        }
        this.soapServiceHelper.assertCanView(space);
        this.soapServiceHelper.assertCanAdminister(space);
        this.spaceManager.removeSpace(space);
        return Boolean.TRUE;
    }

    public String exportSpace(String spaceKey, String exportType) throws RemoteException {
        return this.exportSpace(spaceKey, exportType, false);
    }

    public String exportSpace(String spaceKey, String exportType, boolean exportAll) throws RemoteException {
        String downloadPath;
        if (exportType.equals("all")) {
            exportType = "TYPE_XML";
        }
        if (!this.importExportManager.getImportExportTypeSpecifications().contains(exportType)) {
            throw new RemoteException("Invalid export type: [" + exportType + "]");
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new RemoteException("Invalid spaceKey: [" + spaceKey + "]");
        }
        this.soapServiceHelper.assertCanExport(space);
        User user = AuthenticatedUserThreadLocal.getUser();
        try {
            DefaultExportContext context = new DefaultExportContext();
            context.setType(exportType);
            context.setScope("space");
            context.setExportComments(true);
            context.setExportAttachments(true);
            context.setUser(user);
            context.addWorkingEntity((ConfluenceEntityObject)space);
            context.setContentTree(this.importExportManager.getContentTree(user, space));
            if (exportAll && "TYPE_XML".equals(exportType)) {
                if (this.isSpaceAdminOrConfAdmin(space)) {
                    context.setExportAll(true);
                } else {
                    throw new NotPermittedException("Not permitted to export restricted pages in the space.");
                }
            }
            String archivePath = this.importExportManager.exportAs((ExportContext)context, new ProgressMeter());
            downloadPath = this.importExportManager.prepareDownloadPath(archivePath);
            this.gateKeeper.addKey(downloadPath, user);
        }
        catch (ImportExportException e) {
            return "Could not export space: " + (Object)((Object)e);
        }
        catch (IOException e) {
            return "Could not export space: " + e;
        }
        return this.settingsManager.getGlobalSettings().getBaseUrl() + downloadPath;
    }

    private boolean isSpaceAdminOrConfAdmin(Space space) {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, (Object)space) || this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setSpaceGroupManager(SpaceGroupManager spaceGroupManager) {
        this.spaceGroupManager = spaceGroupManager;
    }

    public void setSetSpacePermissionChecker(SetSpacePermissionChecker setSpacePermissionChecker) {
        this.setSpacePermissionChecker = setSpacePermissionChecker;
    }

    public void setAnonymousUserPermissionsService(AnonymousUserPermissionsService anonymousUserPermissionsService) {
        this.anonymousUserPermissionsService = anonymousUserPermissionsService;
    }

    private class UserOrGroupResolver {
        private String userName = null;
        private String groupName = null;

        public UserOrGroupResolver(String remoteEntityName) throws RemoteException {
            if (remoteEntityName != null) {
                User user = SpacesSoapService.this.userAccessor.getUser(remoteEntityName);
                if (user == null) {
                    Group group = SpacesSoapService.this.userAccessor.getGroup(remoteEntityName);
                    if (group == null) {
                        throw new RemoteException("No user or group with the name '" + remoteEntityName + "' exists.");
                    }
                    this.groupName = group.getName();
                } else {
                    this.userName = user.getName();
                }
            }
        }

        public String getUserName() {
            return this.userName;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }
}

