/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;

public class SoapServiceHelperImpl
implements SoapServiceHelper {
    protected SpaceManager spaceManager;
    protected PermissionManager permissionManager;
    protected PageManager pageManager;
    protected LinkManager linkManager;
    protected UserAccessor userAccessor;
    protected ContentEntityManager contentEntityManager;

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public ContentEntityObject retrieveContent(long contentId) throws RemoteException {
        ContentEntityObject content;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)(content = this.contentEntityManager.getById(contentId)))) {
            throw new RemoteException("You're not allowed to view that content, or it does not exist.");
        }
        return content;
    }

    @Override
    public Space retrieveSpace(String spaceKey) throws RemoteException {
        Space space;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)(space = this.spaceManager.getSpace(spaceKey)))) {
            throw new RemoteException("You're not allowed to view that space, or it does not exist.");
        }
        return space;
    }

    @Override
    public AbstractPage retrieveAbstractPage(long abstractPageId) throws RemoteException {
        AbstractPage page = this.pageManager.getAbstractPage(abstractPageId);
        this.assertCanView(page);
        return page;
    }

    @Override
    public Page retrievePage(String spaceKey, String pageTitle) throws RemoteException {
        Page page = this.pageManager.getPage(spaceKey, pageTitle);
        this.assertCanView((AbstractPage)page);
        return page;
    }

    @Override
    public User retrieveUser(String username) throws RemoteException {
        User user = this.userAccessor.getUser(username);
        if (user == null) {
            throw new RemoteException("The user '" + username + "' does not exist.");
        }
        return user;
    }

    @Override
    public void assertCanView(AbstractPage page) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (page != null && page.getOriginalVersion() != null) {
            page = (AbstractPage)page.getOriginalVersion();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page)) {
            throw new RemoteException("You're not allowed to view that page, or it does not exist.");
        }
    }

    @Override
    public void assertCanView(Space space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space)) {
            throw new NotPermittedException("Space does not exist, or you do not have permission to view it.");
        }
    }

    @Override
    public void assertCanModifyObject(Object obj, String typeDescription) throws NotPermittedException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, obj)) {
            throw new NotPermittedException("You do not have permission to edit " + typeDescription);
        }
    }

    @Override
    public void assertCanCreatePage(Space space) throws RemoteException {
        this.assertCanCreate(space, Page.class, "pages");
    }

    @Override
    public void assertCanCreateBlogPost(Space space) throws RemoteException {
        this.assertCanCreate(space, BlogPost.class, "blog posts");
    }

    private void assertCanCreate(Space space, Class typeToCreate, String typeDescription) throws RemoteException {
        this.assertCanView(space);
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasCreatePermission(user, (Object)space, typeToCreate)) {
            throw new NotPermittedException("You do not have permission to create " + typeDescription + " in this space.");
        }
    }

    @Override
    public void assertCanModify(AbstractPage page) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, (Object)page)) {
            throw new NotPermittedException("You do not have permission to edit this page");
        }
    }

    @Override
    public void assertCanRemove(AbstractPage page) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.REMOVE, (Object)page)) {
            throw new NotPermittedException("You do not have permission to remove this page");
        }
    }

    @Override
    public void assertCanAdminister() throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new NotPermittedException("You don't have the 'Confluence Administrator' permission.");
        }
    }

    @Override
    public void assertCanExport(Space space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.hasPermission(user, Permission.EXPORT, space)) {
            throw new NotPermittedException("You don't have permission to export the space: " + space.getKey());
        }
    }

    @Override
    public void assertCanAdminister(Space space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.hasPermission(user, Permission.ADMINISTER, space)) {
            throw new NotPermittedException("You don't have permission to administer the space: " + space.getKey());
        }
    }

    private boolean hasPermission(User user, Permission permission, Space space) {
        return this.permissionManager.hasPermission(user, permission, (Object)space);
    }
}

