/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.content.service.comment.CreateCommentCommand;
import com.atlassian.confluence.content.service.comment.EditCommentCommand;
import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.DuplicateDataRuntimeException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.VersionMismatchException;
import com.atlassian.confluence.rpc.soap.SoapUtils;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermissionSet;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentSummaries;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePageUpdateOptions;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.DateRangeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PagesSoapService {
    private AttachmentManager attachmentManager;
    private EventManager eventManager;
    private PageManager pageManager;
    private ContentEntityManager contentEntityManager;
    private PermissionManager permissionManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private BootstrapManager bootstrapManager;
    private TrashManager trashManager;
    private SoapServiceHelper soapServiceHelper;
    private LocaleManager localeManager;
    private ContentPermissionManager contentPermissionManager;
    private PageService pageService;
    private CommentService commentService;
    private SpaceService spaceService;
    private PredefinedSearchBuilder predefinedSearchBuilder;
    private SearchManager searchManager;
    private I18NBeanFactory i18NBeanFactory;

    public RemotePageSummary[] getPages(String spaceKey) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        return SoapUtils.getPageSummaries(this.getPermittedEntities(this.pageManager.getPages(space, true)));
    }

    public RemotePage getPage(long pageId) throws RemoteException {
        return new RemotePage((Page)this.soapServiceHelper.retrieveAbstractPage(pageId));
    }

    public RemotePage getPage(String spaceKey, String pageTitle) throws RemoteException {
        return new RemotePage(this.soapServiceHelper.retrievePage(spaceKey, pageTitle));
    }

    public RemoteComment[] getComments(long pageId) throws RemoteException {
        AbstractPage p = this.soapServiceHelper.retrieveAbstractPage(pageId);
        return SoapUtils.getComments(p.getComments());
    }

    public RemoteComment getComment(long commentId) throws RemoteException {
        ContentEntityObject object = this.contentEntityManager.getById(commentId);
        if (object == null || !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)object)) {
            throw new RemoteException("You do not have permission to view the comment, or it does not exist.");
        }
        if (!(object instanceof Comment)) {
            throw new RemoteException("Object for given comment ID is not a comment.");
        }
        Comment comment = (Comment)object;
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)comment.getPage())) {
            throw new RemoteException("You do not have permission to view the comment, or it does not exist.");
        }
        return new RemoteComment(comment);
    }

    public RemoteComment addComment(RemoteComment comment) throws NotPermittedException, RemoteException {
        CreateCommentCommand command = comment.getParentId() == 0L ? this.commentService.newCreateCommentCommand(comment.getPageId(), comment.getContent()) : this.commentService.newCreateCommentCommand(comment.getPageId(), comment.getParentId(), comment.getContent());
        this.executeCommand((ServiceCommand)command);
        return new RemoteComment(command.getComment());
    }

    public RemoteComment editComment(RemoteComment rComment) throws RemoteException {
        EditCommentCommand command = this.commentService.newEditCommentCommand(rComment.getId(), rComment.getContent());
        this.executeCommand((ServiceCommand)command);
        return new RemoteComment(command.getComment());
    }

    public boolean removeComment(long commentId) throws NotPermittedException, RemoteException {
        this.executeCommand((ServiceCommand)this.commentService.newDeleteCommentCommand(commentId));
        return true;
    }

    private void executeCommand(ServiceCommand command) throws RemoteException {
        try {
            command.execute();
        }
        catch (NotAuthorizedException e) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        catch (NotValidException e) {
            throw new RemoteException(this.validationErrorsToString(command));
        }
    }

    private String validationErrorsToString(ServiceCommand command) {
        StringBuffer validationErrors = new StringBuffer();
        boolean first = true;
        for (ValidationError error : command.getValidationErrors()) {
            if (first) {
                first = false;
            } else {
                validationErrors.append(", ");
            }
            User user = AuthenticatedUserThreadLocal.getUser();
            validationErrors.append(this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(user)).getText(error.getMessageKey(), error.getArgs()));
        }
        return validationErrors.toString();
    }

    public RemotePageSummary[] getDescendents(long pageId) throws RemoteException {
        AbstractPage p = this.soapServiceHelper.retrieveAbstractPage(pageId);
        if (p instanceof Page) {
            Page page = (Page)p;
            List permittedDescendants = this.getPermittedEntities(this.pageManager.getDescendents(page));
            return SoapUtils.getPageSummaries(permittedDescendants);
        }
        throw new RemoteException(pageId + " is not a page?");
    }

    public RemotePageSummary[] getTopLevelPages(String spaceKey) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        if (space == null) {
            throw new RemoteException(spaceKey + " is not a space?");
        }
        List permittedPages = this.getPermittedEntities(this.pageManager.getTopLevelPages(space));
        return SoapUtils.getPageSummaries(permittedPages);
    }

    public RemotePageSummary[] getAncestors(long pageId) throws RemoteException {
        AbstractPage p = this.soapServiceHelper.retrieveAbstractPage(pageId);
        if (p instanceof Page) {
            Page page = (Page)p;
            return SoapUtils.getPageSummaries(this.getPermittedEntities(page.getAncestors()));
        }
        throw new RemoteException(pageId + " is not a page?");
    }

    public RemotePageSummary[] getChildren(long pageId) throws RemoteException {
        AbstractPage p = this.soapServiceHelper.retrieveAbstractPage(pageId);
        if (p instanceof Page) {
            Page page = (Page)p;
            List permittedPages = this.getPermittedEntities(page.getSortedChildren());
            return SoapUtils.getPageSummaries(permittedPages);
        }
        throw new RemoteException(pageId + " is not a page?");
    }

    public RemoteAttachment[] getAttachments(long pageId) throws RemoteException {
        AbstractPage p = this.soapServiceHelper.retrieveAbstractPage(pageId);
        return SoapUtils.getAttachments(this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)p));
    }

    public RemotePageHistory[] getPageHistory(long pageId) throws RemoteException {
        AbstractPage p = this.soapServiceHelper.retrieveAbstractPage(pageId);
        if (p.getOriginalVersion() != null) {
            throw new VersionMismatchException("This is not the most recent version of this page");
        }
        return SoapUtils.getPageHistory(p, this.pageManager);
    }

    public Boolean movePageToTopLevel(long pageId, String targetSpaceKey) throws RemoteException {
        MovePageCommand command = this.pageService.newMovePageCommand(this.pageService.getIdPageLocator(pageId), this.spaceService.getKeySpaceLocator(targetSpaceKey));
        this.executeCommand((ServiceCommand)command);
        return Boolean.TRUE;
    }

    public Boolean movePage(long sourcePageId, long targetPageId, String position) throws RemoteException {
        MovePageCommand command = this.pageService.newMovePageCommand(this.pageService.getIdPageLocator(sourcePageId), this.pageService.getIdPageLocator(targetPageId), position);
        this.executeCommand((ServiceCommand)command);
        return Boolean.TRUE;
    }

    public Boolean removePage(long pageId) throws RemoteException {
        AbstractPage page = this.soapServiceHelper.retrieveAbstractPage(pageId);
        this.soapServiceHelper.assertCanRemove(page);
        if (page.getOriginalVersion() != null) {
            throw new RemoteException("You can't remove an old version of the page - remove the current version.");
        }
        if (page.isDeleted()) {
            return Boolean.TRUE;
        }
        this.pageManager.trashPage(page);
        return Boolean.TRUE;
    }

    public RemoteSearchResult[] search(String query, Map params, int maxResults) throws RemoteException {
        SearchResults searchResults;
        String typeValue;
        if (StringUtils.isBlank((String)query)) {
            throw new RemoteException((Throwable)new IllegalArgumentException("A query string must be supplied."));
        }
        SearchQueryParameters searchParams = new SearchQueryParameters(query);
        if (params.containsKey("spaceKey")) {
            String spaceKey = (String)params.get("spaceKey");
            SpaceCategoryEnum spaceCategory = SpaceCategoryEnum.get((String)spaceKey);
            if (spaceCategory != null) {
                searchParams.setCategory(spaceCategory);
            } else {
                searchParams.setSpaceKey(spaceKey);
            }
        }
        if (params.containsKey("type") && !"all".equalsIgnoreCase(typeValue = (String)params.get("type"))) {
            ContentTypeEnum contentType = ContentTypeEnum.getByRepresentation((String)typeValue);
            if (contentType == null) {
                throw new RemoteException("The supplied type parameter value of " + typeValue + " is an unknown content type.");
            }
            searchParams.setContentType(contentType);
        }
        if (params.containsKey("modified")) {
            try {
                DateRangeEnum lastModifiedEnum = Enum.valueOf(DateRangeEnum.class, (String)params.get("modified"));
                searchParams.setLastModified(lastModifiedEnum.dateRange());
            }
            catch (IllegalArgumentException ex) {
                throw new RemoteException("The supplied date range parameter was not recognised.", (Throwable)ex);
            }
        }
        if (params.containsKey("contributor")) {
            searchParams.setContributor((String)params.get("contributor"));
        }
        ISearch search = this.predefinedSearchBuilder.buildSiteSearch(searchParams, 0, maxResults);
        try {
            searchResults = this.searchManager.search(search);
        }
        catch (IllegalArgumentException e) {
            throw new RemoteException("Invalid query params specified: [" + searchParams + "] produced an invalid search query.", (Throwable)e);
        }
        catch (InvalidSearchException e) {
            throw new RemoteException("Failure executing search for term " + searchParams.getQuery(), (Throwable)e);
        }
        this.eventManager.publishEvent((Event)new SearchPerformedEvent((Object)this, search.getQuery(), AuthenticatedUserThreadLocal.getUser(), searchResults.size()));
        ArrayList<RemoteSearchResult> remoteSearchResults = new ArrayList<RemoteSearchResult>(searchResults.size());
        for (SearchResult searchResult : searchResults.getAll()) {
            remoteSearchResults.add(new RemoteSearchResult(searchResult, query));
        }
        return remoteSearchResults.toArray(new RemoteSearchResult[remoteSearchResults.size()]);
    }

    public RemoteSearchResult[] search(String query, int maxResults) throws RemoteException {
        return this.search(query, Collections.EMPTY_MAP, maxResults);
    }

    public String renderContent(String spaceKey, long pageId, String newContent) throws RemoteException {
        return this.renderContent(spaceKey, pageId, newContent, null);
    }

    public String renderContent(String spaceKey, long pageId, String newContent, Map parameters) throws RemoteException {
        PageContext ctx;
        AbstractPage page = null;
        if (pageId > 0L) {
            page = this.soapServiceHelper.retrieveAbstractPage(pageId);
            ctx = page.toPageContext();
        } else {
            if (!TextUtils.stringSet((String)spaceKey)) {
                throw new RemoteException("You must specify a space key to render non existant content.");
            }
            ctx = new PageContext(spaceKey);
        }
        String contentToRender = newContent;
        if (!TextUtils.stringSet((String)contentToRender)) {
            contentToRender = page.getContent();
        }
        String renderedContent = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)ctx, contentToRender);
        if (parameters != null && parameters.containsKey("style") && "clean".equalsIgnoreCase((String)parameters.get("style"))) {
            return "<div id=\"ConfluenceContent\">" + renderedContent + "</div>";
        }
        StringBuffer basicRenderedPage = new StringBuffer("<html><head>\n");
        basicRenderedPage.append("<title>").append(page != null ? page.getTitle() : "Untitled").append("</title>\n");
        basicRenderedPage.append("<style>\n").append(ConfluenceRenderUtils.renderSpaceStylesheet((Space)(page != null ? page.getSpace() : null))).append("</style>\n");
        basicRenderedPage.append("<base href=\"").append(this.bootstrapManager.getBaseUrl()).append("\"/>\n");
        basicRenderedPage.append("</head>\n<body>\n<div id=\"Content\" style=\"padding: 5px;\">\n");
        basicRenderedPage.append(renderedContent);
        basicRenderedPage.append("\n</div>\n</body></html>");
        return basicRenderedPage.toString();
    }

    public RemotePage storePage(RemotePage rpage) throws RemoteException {
        if (rpage.getId() == 0L) {
            return this.createPage(rpage);
        }
        return this.updatePage(rpage, new RemotePageUpdateOptions());
    }

    private RemotePage createPage(RemotePage rpage) throws RemoteException {
        rpage.setTitle(rpage.getTitle().trim());
        Space space = this.soapServiceHelper.retrieveSpace(rpage.getSpace());
        this.soapServiceHelper.assertCanView(space);
        this.soapServiceHelper.assertCanCreatePage(space);
        Page page = new Page();
        page.setSpace(space);
        page.setTitle(rpage.getTitle());
        page.setContent(rpage.getContent());
        if (rpage.getParentId() > 0L) {
            Page potentialParent = this.pageManager.getPage(rpage.getParentId());
            if (potentialParent == null) {
                throw new RemoteException("The parent ID specified does not exist?");
            }
            potentialParent.addChild(page);
        }
        try {
            this.pageManager.saveContentEntity((ContentEntityObject)page, null);
        }
        catch (DuplicateDataRuntimeException ex) {
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
        return new RemotePage(page);
    }

    public RemotePage updatePage(RemotePage rpage, RemotePageUpdateOptions options) throws RemoteException {
        Page originalPage;
        rpage.setTitle(rpage.getTitle().trim());
        Page page = (Page)this.soapServiceHelper.retrieveAbstractPage(rpage.getId());
        this.soapServiceHelper.assertCanModify((AbstractPage)page);
        if (!page.getSpace().getKey().equals(rpage.getSpace())) {
            throw new RemoteException("You can't change an existing page's space.");
        }
        if (page.getVersion() != rpage.getVersion()) {
            throw new VersionMismatchException("You're trying to edit an outdated version of that page.");
        }
        try {
            originalPage = (Page)page.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InfrastructureException("Uh oh, couldn't clone a page?!");
        }
        boolean storeRequired = false;
        if (!page.getTitle().equals(rpage.getTitle())) {
            page.setTitle(rpage.getTitle());
            storeRequired = true;
        }
        if (!rpage.getContent().equals(page.getContent())) {
            page.setContent(rpage.getContent());
            storeRequired = true;
        }
        Page potentialParent = rpage.getParentId() == 0L ? null : this.pageManager.getPage(rpage.getParentId());
        Page existingParent = page.getParent();
        if (potentialParent == null) {
            if (existingParent != null) {
                existingParent.removeChild(page);
                page.setParentPage(null);
                storeRequired = true;
            }
        } else if (existingParent == null) {
            potentialParent.addChild(page);
            storeRequired = true;
        } else if (existingParent.getId() != potentialParent.getId()) {
            existingParent.removeChild(page);
            potentialParent.addChild(page);
            storeRequired = true;
        }
        if (storeRequired) {
            DefaultSaveContext saveContext = new DefaultSaveContext();
            page.setVersionComment(options.getVersionComment());
            saveContext.setUpdateLastModifier(true);
            saveContext.setMinorEdit(options.isMinorEdit());
            try {
                this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, (SaveContext)saveContext);
            }
            catch (IllegalArgumentException ex) {
                throw new RemoteException(ex.getMessage(), ex.getCause());
            }
            this.renderContent(page.getSpaceKey(), page.getId(), page.getContent());
        }
        return new RemotePage(page);
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public boolean setContentPermissions(long contentId, String permissionType, RemoteContentPermission[] remoteContentPermissions) throws RemoteException {
        AbstractPage page = this.soapServiceHelper.retrieveAbstractPage(contentId);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, (Object)page)) {
            throw new NotPermittedException("You do not have permissions to set page level restrictions on this page.");
        }
        ArrayList<ContentPermission> contentPermissionList = new ArrayList<ContentPermission>();
        for (int i = 0; i < remoteContentPermissions.length; ++i) {
            ContentPermission newPermission;
            RemoteContentPermission remoteContentPermission = remoteContentPermissions[i];
            if (remoteContentPermission.getType() != null && !permissionType.equals(remoteContentPermission.getType())) {
                throw new RemoteException("Content permission type does not match supplied permission type");
            }
            if (remoteContentPermission.getUserName() != null) {
                newPermission = ContentPermission.createUserPermission((String)permissionType, (String)remoteContentPermission.getUserName());
            } else if (remoteContentPermission.getGroupName() != null) {
                newPermission = ContentPermission.createGroupPermission((String)permissionType, (String)remoteContentPermission.getGroupName());
            } else {
                throw new RemoteException("Content permissions must include either a user or group name");
            }
            if (contentPermissionList.contains(newPermission)) {
                throw new RemoteException("The specified list of permissions contains duplicate permissions.");
            }
            contentPermissionList.add(newPermission);
        }
        this.contentPermissionManager.setContentPermissions(contentPermissionList, (ContentEntityObject)page, permissionType);
        return true;
    }

    public RemoteContentPermissionSet[] getContentPermissionSets(long contentId) throws RemoteException {
        AbstractPage page = this.soapServiceHelper.retrieveAbstractPage(contentId);
        ArrayList<RemoteContentPermissionSet> remoteContentPermissionSets = new ArrayList<RemoteContentPermissionSet>();
        if (page.hasPermissions("View")) {
            remoteContentPermissionSets.add(new RemoteContentPermissionSet(page.getContentPermissionSet("View")));
        }
        if (page.hasPermissions("Edit")) {
            remoteContentPermissionSets.add(new RemoteContentPermissionSet(page.getContentPermissionSet("Edit")));
        }
        return remoteContentPermissionSets.toArray(new RemoteContentPermissionSet[remoteContentPermissionSets.size()]);
    }

    public RemoteContentPermissionSet getContentPermissionSet(long contentId, String permissionType) throws RemoteException {
        AbstractPage page = this.soapServiceHelper.retrieveAbstractPage(contentId);
        if (page.hasPermissions(permissionType)) {
            return new RemoteContentPermissionSet(page.getContentPermissionSet(permissionType));
        }
        return new RemoteContentPermissionSet(permissionType);
    }

    public RemotePermission[] getPermissions(long pageId) throws RemoteException {
        AbstractPage page = this.soapServiceHelper.retrieveAbstractPage(pageId);
        ArrayList permissions = new ArrayList();
        this.addContentPermissions(permissions, page, "View");
        this.addContentPermissions(permissions, page, "Edit");
        return permissions.toArray(new RemotePermission[permissions.size()]);
    }

    public RemoteContentSummaries getTrashContents(String spaceKey, int offset, int count) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        this.soapServiceHelper.assertCanAdminister(space);
        int availableTrash = this.trashManager.getNumberOfItemsInTrash(space);
        List trashItems = this.trashManager.getTrashContents(space, offset, count);
        RemoteContentSummary[] summaries = new RemoteContentSummary[trashItems.size()];
        int i = 0;
        for (ContentEntityObject trashItem : trashItems) {
            summaries[i++] = new RemoteContentSummary(trashItem);
        }
        return new RemoteContentSummaries(availableTrash, offset, summaries);
    }

    public boolean purgeFromTrash(String spaceKey, long contentId) throws RemoteException {
        SpaceContentEntityObject spaceContent;
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        this.soapServiceHelper.assertCanAdminister(space);
        ContentEntityObject content = this.soapServiceHelper.retrieveContent(contentId);
        SpaceContentEntityObject spaceContentEntityObject = spaceContent = content instanceof SpaceContentEntityObject ? (SpaceContentEntityObject)content : null;
        if (spaceContent == null || !spaceContent.getSpace().equals((Object)space)) {
            throw new RemoteException("Content with id " + contentId + " is not in space " + spaceKey);
        }
        if (!"deleted".equals(content.getContentStatus())) {
            throw new RemoteException("Content with id " + contentId + " in space " + spaceKey + " is not in the trash.");
        }
        return this.trashManager.purge(spaceKey, contentId);
    }

    public boolean emptyTrash(String spaceKey) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        this.soapServiceHelper.assertCanAdminister(space);
        this.trashManager.emptyTrash(space);
        return true;
    }

    private void addContentPermissions(List permissions, AbstractPage page, String permissionType) {
        if (page.hasPermissions(permissionType)) {
            for (ContentPermission permission : page.getContentPermissionSet(permissionType)) {
                permissions.add(new RemotePermission(permission));
            }
        }
    }

    private List getPermittedEntities(List entities) {
        return this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, entities);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    public void setPredefinedSearchBuilder(PredefinedSearchBuilder predefinedSearchBuilder) {
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public void setTrashManager(TrashManager trashManager) {
        this.trashManager = trashManager;
    }
}

