/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.NotFoundException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class NotificationsSoapService {
    private NotificationManager notificationManager;
    private PermissionManager permissionManager;
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;

    public boolean watchPage(long pageId) throws RemoteException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (currentUser == null) {
            throw new NotPermittedException("Anonymous users cannot configure watches");
        }
        AbstractPage page = this.getPage(pageId);
        if (this.notificationManager.isUserWatchingPageOrSpace(currentUser, page.getSpace(), page)) {
            return false;
        }
        this.notificationManager.addPageNotification(currentUser, page);
        return true;
    }

    public boolean watchPageForUser(long pageId, String username) throws RemoteException {
        AbstractPage page = this.getPage(pageId);
        this.checkSpaceAdministerPermission(page.getSpace(), username);
        User user = this.checkUser(username);
        if (this.notificationManager.isUserWatchingPageOrSpace(user, page.getSpace(), page)) {
            return false;
        }
        this.notificationManager.addPageNotification(user, page);
        return true;
    }

    public boolean watchSpace(String spaceKey) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (user == null) {
            throw new NotPermittedException("Anonymous users cannot configure watches");
        }
        Space space = this.checkSpace(spaceKey);
        this.checkSpaceViewPermission(user, space);
        if (this.notificationManager.getNotificationByUserAndSpace(user, space) != null) {
            return false;
        }
        this.notificationManager.addSpaceNotification(user, space);
        return true;
    }

    public boolean isWatchingPage(long pageId, String username) throws RemoteException {
        AbstractPage page = this.getPage(pageId);
        this.checkSpaceAdministerPermission(page.getSpace(), username);
        User user = this.checkUser(username);
        return this.notificationManager.getNotificationByUserAndPage(user, page) != null;
    }

    public RemoteUser[] getWatchersForPage(long pageId) throws RemoteException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        AbstractPage page = this.getPage(pageId);
        this.checkSpaceAdministerPermission(page.getSpace(), null);
        return this.toRemoteUsers(this.notificationManager.getNotificationsByPage(page));
    }

    public boolean isWatchingSpace(String spaceKey, String username) throws RemoteException {
        Space space = this.checkSpace(spaceKey);
        this.checkSpaceAdministerPermission(space, username);
        User user = this.checkUser(username);
        return this.notificationManager.getNotificationByUserAndSpace(user, space) != null;
    }

    public boolean isWatchingSpaceForType(String spaceKey, String contentType, String username) throws RemoteException {
        Space space = this.checkSpace(spaceKey);
        this.checkSpaceAdministerPermission(space, username);
        User user = this.checkUser(username);
        ContentTypeEnum type = ContentTypeEnum.getByRepresentation((String)contentType);
        if (type == null) {
            throw new NotFoundException("ContentTypeEnum not found with type: " + contentType);
        }
        return this.notificationManager.getNotificationByUserAndSpaceAndType(user, space, type) != null;
    }

    public RemoteUser[] getWatchersForSpace(String spaceKey) throws RemoteException {
        Space space = this.checkSpace(spaceKey);
        this.checkSpaceAdministerPermission(space, null);
        return this.toRemoteUsers(this.notificationManager.getNotificationsBySpaceAndType(space, null));
    }

    private AbstractPage getPage(long pageId) throws NotFoundException, NotPermittedException {
        AbstractPage page = this.pageManager.getAbstractPage(pageId).getLatestVersion();
        if (page == null) {
            throw new NotFoundException("No page exists with ID: " + pageId);
        }
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.VIEW, (Object)page)) {
            throw new NotPermittedException("You do not have permission to view that page");
        }
        return page;
    }

    private void checkSpaceAdministerPermission(Space space, String username) throws NotPermittedException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (StringUtils.isNotBlank((String)username) && currentUser.getName().equalsIgnoreCase(username)) {
            return;
        }
        if (!this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)space)) {
            throw new NotPermittedException("You do not have permission to administer that space");
        }
    }

    private void checkSpaceViewPermission(User user, Space space) throws NotPermittedException {
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space)) {
            throw new NotPermittedException("You do not have permission to view that space");
        }
    }

    private User checkUser(String username) throws NotFoundException {
        User user = this.userAccessor.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found with username: " + username);
        }
        return user;
    }

    private Space checkSpace(String spaceKey) throws NotFoundException {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new NotFoundException("No space exists with key: " + spaceKey);
        }
        return space;
    }

    private RemoteUser[] toRemoteUsers(List<Notification> notifications) {
        Object[] result = new RemoteUser[notifications.size()];
        for (int i = 0; i < result.length; ++i) {
            Notification notification = notifications.get(i);
            User user = this.userAccessor.getUser(notification.getUserName());
            if (user != null) {
                result[i] = new RemoteUser(user);
                continue;
            }
            RemoteUser remoteUser = new RemoteUser();
            remoteUser.setName(notification.getUserName());
            result[i] = remoteUser;
        }
        Arrays.sort(result);
        return result;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

