/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.index.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.plugins.index.api.AnalyzerDescriptorProvider;
import com.atlassian.confluence.plugins.index.api.CharFilterDescriptor;
import com.atlassian.confluence.plugins.index.api.LanguageDescriptor;
import com.atlassian.confluence.plugins.index.api.TokenFilterDescriptor;
import com.atlassian.confluence.plugins.index.api.TokenizerDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

@ExperimentalApi
public class AnalyzerDescriptor
implements AnalyzerDescriptorProvider {
    private final Collection<CharFilterDescriptor> charFilters;
    private final TokenizerDescriptor tokenizer;
    private final Collection<TokenFilterDescriptor> tokenFilters;

    private AnalyzerDescriptor(Builder builder) {
        this.charFilters = new ArrayList<CharFilterDescriptor>(Objects.requireNonNull(builder.charFilters, "charFilters"));
        this.tokenizer = Objects.requireNonNull(builder.tokenizer, "tokenizer");
        this.tokenFilters = new ArrayList<TokenFilterDescriptor>(Objects.requireNonNull(builder.tokenFilters, "tokenFilter"));
    }

    public Collection<CharFilterDescriptor> getCharFilters() {
        return Collections.unmodifiableCollection(this.charFilters);
    }

    public TokenizerDescriptor getTokenizer() {
        return this.tokenizer;
    }

    public Collection<TokenFilterDescriptor> getTokenFilters() {
        return Collections.unmodifiableCollection(this.tokenFilters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzerDescriptor)) {
            return false;
        }
        AnalyzerDescriptor that = (AnalyzerDescriptor)o;
        return Objects.equals(this.getCharFilters(), that.getCharFilters()) && Objects.equals(this.getTokenizer(), that.getTokenizer()) && Objects.equals(this.getTokenFilters(), that.getTokenFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getCharFilters(), this.getTokenizer(), this.getTokenFilters());
    }

    public static Builder builder(TokenizerDescriptor tokenizer) {
        return new Builder(tokenizer);
    }

    @Override
    public Optional<AnalyzerDescriptor> getAnalyzer(LanguageDescriptor language) {
        return Optional.of(this);
    }

    public static class Builder {
        private Collection<CharFilterDescriptor> charFilters = new ArrayList<CharFilterDescriptor>();
        private TokenizerDescriptor tokenizer;
        private Collection<TokenFilterDescriptor> tokenFilters;

        private Builder(TokenizerDescriptor tokenizer) {
            this.tokenizer = Objects.requireNonNull(tokenizer);
            this.tokenFilters = new ArrayList<TokenFilterDescriptor>();
        }

        public Builder charFilter(CharFilterDescriptor charFilter) {
            this.charFilters.add(charFilter);
            return this;
        }

        public Builder tokenFilter(TokenFilterDescriptor tokenFilter) {
            this.tokenFilters.add(tokenFilter);
            return this;
        }

        public AnalyzerDescriptor build() {
            return new AnalyzerDescriptor(this);
        }
    }
}

