package com.atlassian.confluence.plugins.createcontent.services.model;

import java.util.Map;

/**
 * Provides getters for Create-Blueprint-Page requests.
 * <p>
 * The getters correspond to the data provided in the REST/Action call and resolved by the ContentBlueprintService.
 *
 * @since 2.0
 */
public interface CreateBlueprintPageEntity {
    String getSpaceKey();

    long getParentPageId();

    String getContentBlueprintId();

    String getModuleCompleteKey();

    Map<String, Object> getContext();

    String getTitle();

    String getViewPermissionsUsers();

    String getContentTemplateId();

    String getContentTemplateKey();
}
