package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.confluence.plugins.createcontent.rest.SpaceResultsEntity;

import java.util.List;
import java.util.Map;

public interface SpaceCollectionService {
    /**
     * @param promotedSpaceKeys   list of space keys to retrieve, nullable
     * @param promotedSpacesLimit limit number to return for promoted spaces
     * @param otherSpacesLimit    limit number to return for other spaces
     * @param spacePermission     Space permission as stated in com.atlassian.confluence.security.SpacePermission
     * @return
     */
    public Map<String, SpaceResultsEntity> getSpaces(List<String> promotedSpaceKeys, int promotedSpacesLimit, int otherSpacesLimit, String spacePermission);
}
