package com.atlassian.confluence.plugins.createcontent.contextproviders;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.createcontent.rest.SpaceResultsEntity;
import com.atlassian.confluence.plugins.createcontent.services.SpaceCollectionService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.atlassian.confluence.security.SpacePermission.CREATEEDIT_PAGE_PERMISSION;
import static org.slf4j.LoggerFactory.getLogger;

public class QuickCreateUrlContextProvider implements ContextProvider {

    private static final Logger log = getLogger(QuickCreateUrlContextProvider.class);

    private final ContextPathHolder contextPathHolder;
    private final SpaceCollectionService spaceCollectionService;

    public QuickCreateUrlContextProvider(ContextPathHolder contextPathHolder, SpaceCollectionService spaceCollectionService) {
        this.contextPathHolder = contextPathHolder;
        this.spaceCollectionService = spaceCollectionService;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    public Map<String, Object> getContextMap(Map<String, Object> context) {
        // getContextMap() is called when rendering labels, tooltips ..., we don't want to process in that case
        Object renderingQuickURL = context.get("renderingQuickURL");
        if (renderingQuickURL == null || !Boolean.parseBoolean(renderingQuickURL.toString())) {
            return context;
        }

        String quickUrl = contextPathHolder.getContextPath() + "/pages/createpage.action?spaceKey=";
        Space space = (Space) context.get("space");
        AbstractPage page = (AbstractPage) context.get("page");
        if (space != null) {
            quickUrl += space.getKey();
            if (page != null) {
                quickUrl += "&fromPageId=" + page.getId();
            }
        } else {
            //if no space, get a default one
            String spaceKey = getDefaultSpaceKey();

            quickUrl += spaceKey;
        }

        quickUrl += "&src=quick-create";
        context.put("quickUrl", quickUrl);
        return context;
    }

    private String getDefaultSpaceKey() {
        String spaceKey = "";
        try {
            List<String> promotedSpaceKeys = new ArrayList<String>();
            Map<String, SpaceResultsEntity> spaces = spaceCollectionService.getSpaces(promotedSpaceKeys, 1, 1, CREATEEDIT_PAGE_PERMISSION);
            if (!CollectionUtils.isEmpty(spaces.get("promotedSpaces").getSpaces())) {
                spaceKey = spaces.get("promotedSpaces").getSpaces().iterator().next().getId();
            } else if (!CollectionUtils.isEmpty(spaces.get("otherSpaces").getSpaces())) {
                spaceKey = spaces.get("otherSpaces").getSpaces().iterator().next().getId();
            }

            if (spaceKey.isEmpty()) {
                log.error("Couldn't find any space with create page permission. CreateContentCondition should have failed "
                        + "and QuickCreateUrlContextProvider.getContextMap() should not be called ");
            }
        } catch (Exception e) {
            log.error("Exception while calculating default space key. Catching to avoid bringing down the whole page.", e);
        }
        return spaceKey;
    }
}
