package com.atlassian.confluence.plugins.createcontent.api.contextproviders;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.plugins.createcontent.BlueprintConstants;
import com.atlassian.plugin.web.ContextProvider;

/**
 * Context keys for use with Blueprints {@link ContextProvider} implementations.
 * <p>
 * These enum values should be used instead of Strings in the deprecated {@link BlueprintConstants} class, but if
 * possible you should have your {@link ContextProvider} implementation extend the {@link AbstractBlueprintContextProvider}
 * abstract class so that you can work with the {@link BlueprintContext} object and not the simple context map.
 */
@ExperimentalApi
public enum BlueprintContextKeys {
    /**
     * The key of the space the Blueprint content will be created in.
     */
    SPACE_KEY("spaceKey"),

    /**
     * The complete plugin-module key of the Blueprint used to create the content.
     */
    BLUEPRINT_MODULE_KEY("blueprintKey"),

    /**
     * The UUID of the Blueprint used to create content.
     */
    BLUEPRINT_ID("blueprintId"),

    /**
     * The label that will be added to the Blueprint Content to identify it.
     */
    TEMPLATE_LABEL("templateLabel"),

    /**
     * The label that will be used for tracking usage of a given Blueprint.
     */
    ANALYTICS_KEY("analyticsKey"),

    /**
     * The action to take after a Blueprint page is started from a template:
     * - 'edit' to create a draft and view it in the Editor
     * - 'view' to create the page and view it
     */
    CREATE_RESULT("createResult"),

    /**
     * If a Blueprint renders a "Create-from-Template" macro, this is the label for the macro's button.
     */
    CREATE_FROM_TEMPLATE_LABEL("createFromTemplateLabel"),

    /**
     * The title that the content (page, blog) should have.
     * <p>
     * Try to use {@link BlueprintContext#setTitle(String)} instead.
     */
    CONTENT_PAGE_TITLE("ContentPageTitle"),

    /**
     * Set to true in the context for a Space Blueprint if pages created in a hierarchy should not be prefixed with
     * the Space home page's title.
     */
    NO_PAGE_TITLE_PREFIX("noPageTitlePrefix");

    private final String key;

    private BlueprintContextKeys(String key) {
        this.key = key;
    }

    public String key() {
        return key;
    }
}
