package com.atlassian.confluence.plugins.createcontent.activeobjects;

import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.schema.Table;

/**
 * A Blueprint that can be backed by a plugin module.
 *
 * @since 1.6
 */
// FIXME: This name is confusing. We use this class for different parts of blueprints besides blueprints themselves
@Table("PluginBackedBp")
public interface PluginBackedBlueprintAo extends UuidBackedAo {
    void setPluginModuleKey(String key);

    String getPluginModuleKey();

    // DB column is still named "NAME" instead of the matching "I18N_NAME_KEY" so we don't end up doing table alterations (risky) without a good motive
    @Mutator("NAME")
    void setI18nNameKey(String name);

    @Accessor("NAME")
    String getI18nNameKey();

    void setPluginClone(boolean isClone);

    /**
     * True if this Blueprint is a vanilla clone of a Plugin-provided Blueprint, with no user alterations.
     */
    boolean isPluginClone();
}
