/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.TesterConfiguration;
import com.atlassian.confluence.plugin.functest.helper.HelperFactory;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapServiceServiceLocator;
import com.atlassian.confluence.plugin.functest.util.ClasspathResourceUtil;
import com.atlassian.confluence.plugin.functest.util.ConfluenceBuildUtil;
import com.atlassian.confluence.plugin.functest.util.PluginMetadataUtil;
import com.thoughtworks.selenium.DefaultSelenium;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import junit.framework.Assert;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumConfluenceWebTester
extends DefaultSelenium
implements ConfluenceWebTester {
    private static final Logger LOG = Logger.getLogger(SeleniumConfluenceWebTester.class);
    private static final Set<String> KEYS_OF_PLUGINS_INSTALLED_BY_TEST_LIBRARY = new HashSet<String>();
    private static final String DEFAULT_PAGE_LOAD_TIMEOUT = "30000";
    private String currentUserName;
    private String currentPassword;
    private String licenseString;
    private final TesterConfiguration testerConfiguration;

    public SeleniumConfluenceWebTester(TesterConfiguration testerConfiguration, int seleniumServerPort, String browserStartCommand) {
        super("localhost", seleniumServerPort, StringUtils.isBlank((String)browserStartCommand) ? "*firefox" : browserStartCommand, testerConfiguration.getBaseUrl());
        this.setCurrentUserName(testerConfiguration.getAdminUserName());
        this.setCurrentPassword(testerConfiguration.getAdminPassword());
        this.licenseString = testerConfiguration.getLicense();
        this.testerConfiguration = testerConfiguration;
    }

    protected String getDefaultPageLoadWaitTimeout() {
        return DEFAULT_PAGE_LOAD_TIMEOUT;
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(this.getDefaultPageLoadWaitTimeout());
    }

    public String getContextPath() {
        return this.testerConfiguration.getContextPath();
    }

    @Override
    public String getAdminUserName() {
        return this.testerConfiguration.getAdminUserName();
    }

    @Override
    public String getAdminPassword() {
        return this.testerConfiguration.getAdminPassword();
    }

    @Override
    public String getCurrentUserName() {
        return this.currentUserName;
    }

    @Override
    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    @Override
    public String getCurrentPassword() {
        return this.currentPassword;
    }

    @Override
    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    @Override
    public String getLicenseString() {
        return this.licenseString;
    }

    @Override
    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    @Override
    public String getBaseUrl() {
        return this.testerConfiguration.getBaseUrl();
    }

    private String getUrl(String pathRelativeToContext) {
        return this.getContextPath() + pathRelativeToContext;
    }

    @Override
    public void login(String username, String password) {
        this.open(this.getUrl("/login.action"));
        this.type("css=form[name='loginform'] input[name='os_username']", username);
        this.type("css=form[name='loginform'] input[name='os_password']", password);
        this.submit("css=form[name='loginform']");
        this.waitForPageToLoad();
        Assert.assertTrue((boolean)this.isElementPresent("css=a#logout-link"));
    }

    @Override
    public void login() {
        this.login(this.getCurrentUserName(), this.getCurrentPassword());
    }

    @Override
    public void logout() {
        this.click("css=a#logout-link");
        this.waitForPageToLoad();
    }

    @Override
    public XmlRpcClient getXmlRpcClient() throws MalformedURLException {
        return new XmlRpcClient(this.getBaseUrl() + "/rpc/xmlrpc");
    }

    @Override
    public String loginToXmlRpcService(String userName, String password) throws XmlRpcException, IOException {
        XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
        return (String)xmlRpcClient.execute("confluence1.login", new Vector<String>(Arrays.asList(userName, password)));
    }

    @Override
    public void logoutFromXmlRpcService(String authenticationToken) {
        if (StringUtils.isNotBlank((String)authenticationToken)) {
            try {
                XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
                xmlRpcClient.execute("confluence1.logout", new Vector<String>(Arrays.asList(authenticationToken)));
            }
            catch (MalformedURLException mUrlE) {
                LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
            }
            catch (XmlRpcException xmlRpcE) {
                LOG.error((Object)"Service request denied.", (Throwable)xmlRpcE);
            }
            catch (RemoteException re) {
                LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
            }
        }
    }

    @Override
    public String loginToXmlRPcService() throws XmlRpcException, IOException {
        return this.loginToXmlRpcService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    @Override
    public ConfluenceSoapService getConfluenceSoapService() throws MalformedURLException, ServiceException {
        ConfluenceSoapServiceServiceLocator confluenceSoapServiceServiceLocator = new ConfluenceSoapServiceServiceLocator();
        return confluenceSoapServiceServiceLocator.getConfluenceserviceV1(new URL(this.getBaseUrl() + "/rpc/soap-axis/confluenceservice-v1?wsdl"));
    }

    @Override
    public String loginToSoapService(String userName, String password) throws MalformedURLException, ServiceException, RemoteException {
        ConfluenceSoapService confluenceSoapService = this.getConfluenceSoapService();
        return StringUtils.isNotBlank((String)userName) ? confluenceSoapService.login(userName, password) : null;
    }

    @Override
    public String loginToSoapService() throws MalformedURLException, ServiceException, RemoteException {
        return this.loginToSoapService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    @Override
    public void logoutFromSoapService(String authenticationToken) {
        try {
            if (null != authenticationToken) {
                this.getConfluenceSoapService().logout(authenticationToken);
            }
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLicense() throws IOException {
        String licenseString = this.getLicenseString();
        if (StringUtils.isNotBlank((String)licenseString)) {
            try {
                Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/license.action"));
                this.type("css=textarea[name='licenseString']", licenseString);
                this.click("css=input[name='update']");
                this.waitForPageToLoad();
                Assert.assertFalse((boolean)this.isTextPresent("License string is too short"));
                Assert.assertFalse((boolean)this.isTextPresent("License was not valid"));
            }
            finally {
                this.dropEscalatedPrivileges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLicense() {
        try {
            Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/refreshlicensing.action"));
        }
        finally {
            this.dropEscalatedPrivileges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installTestLibrary() {
        File testLibraryJar = this.testerConfiguration.getTestLibraryJar();
        if (null != testLibraryJar && testLibraryJar.isFile()) {
            try {
                Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/console.action"));
                String pluginKey = PluginMetadataUtil.getPluginKey(PluginMetadataUtil.getPluginDescriptorDom(testLibraryJar));
                if (!this.isPluginInstalled(pluginKey)) {
                    LOG.info((Object)("Installing test library with key " + pluginKey));
                    this.installPlugin(testLibraryJar);
                } else {
                    LOG.info((Object)"Plugin test library already installed. Skipping installation.");
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Unable to determine plugin key from " + testLibraryJar + SystemUtils.LINE_SEPARATOR + ExceptionUtils.getFullStackTrace((Throwable)e)));
            }
            finally {
                this.dropEscalatedPrivileges();
            }
        }
    }

    private boolean isPluginInstalled(String pluginKey) {
        if (this.isConfluence210AndBelow()) {
            this.open(this.getUrl("/admin/plugins.action?pluginKey=" + pluginKey));
        } else {
            this.open(this.getUrl("/admin/viewplugins.action?pluginKey=" + pluginKey));
        }
        return this.isElementPresent("xpath=//a[text()='Enable plugin']") || this.isElementPresent("xpath=//a[text()='Disable plugin']");
    }

    private boolean isConfluence210AndBelow() {
        return ConfluenceBuildUtil.getBuildNumber() < 1600;
    }

    @Override
    public void installPlugin() {
        File pluginJar = this.testerConfiguration.getPluginJar();
        if (this.testerConfiguration.isInstallPlugin() && null != pluginJar) {
            this.installPlugin(pluginJar);
        }
    }

    @Override
    public void installPlugin(File pluginJar) {
        block5: {
            if (null != pluginJar && pluginJar.isFile()) {
                try {
                    Document pluginDescDom = PluginMetadataUtil.getPluginDescriptorDom(pluginJar);
                    String pluginKey = PluginMetadataUtil.getPluginKey(pluginDescDom);
                    String pluginName = PluginMetadataUtil.getPluginName(pluginDescDom);
                    if (!this.hasTestLibraryInstalledPlugin(pluginKey)) {
                        LOG.info((Object)("Installing plugin \"" + pluginName + "\" with key " + pluginKey));
                        this.installPluginInternal(pluginJar);
                        this.markPluginInstalledByTestLibrary(pluginKey);
                        break block5;
                    }
                    LOG.info((Object)("Plugin \"" + pluginName + "\" already installed. Skipping installation."));
                }
                catch (Exception e) {
                    Assert.fail((String)("Unable to determine plugin key from " + pluginJar + SystemUtils.LINE_SEPARATOR + ExceptionUtils.getFullStackTrace((Throwable)e)));
                }
            } else {
                LOG.warn((Object)("Invalid plugin JAR (" + pluginJar + ") specified for install. Skipping"));
            }
        }
    }

    private boolean hasTestLibraryInstalledPlugin(String pluginKey) {
        return KEYS_OF_PLUGINS_INSTALLED_BY_TEST_LIBRARY.contains(pluginKey);
    }

    private void markPluginInstalledByTestLibrary(String pluginKey) {
        KEYS_OF_PLUGINS_INSTALLED_BY_TEST_LIBRARY.add(pluginKey);
    }

    protected Document parseToDocument(InputStream responseIn) {
        PrintWriter errorWriter = new PrintWriter(new StringWriter());
        Tidy tidy = new Tidy();
        tidy.setErrout(errorWriter);
        tidy.setInputEncoding("UTF-8");
        return tidy.parseDOM(responseIn, null);
    }

    protected XPathExpression compileXPathExpression(String xPathExpression) throws XPathExpressionException {
        return XPathFactory.newInstance().newXPath().compile(xPathExpression);
    }

    private String getXsrfToken(InputStream responseBody) throws IOException {
        try {
            return this.compileXPathExpression("//head/meta[@id='atlassian-token']/@content").evaluate(this.parseToDocument(responseBody));
        }
        catch (XPathExpressionException xpee) {
            LOG.error((Object)"Compile time XPath expression not valid?", (Throwable)xpee);
            Assert.fail((String)"Unable to get atlassian-token");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loginToLocationWithEscalatedPrivileges(HttpClient httpClient, String pathRelativeToBaseUrl) throws IOException {
        String string;
        if (ConfluenceBuildUtil.containsSudoFeature()) {
            GetMethod loginMethod = null;
            try {
                String string2;
                loginMethod = new GetMethod(this.getBaseUrl() + "/authenticate.action");
                loginMethod.setQueryString(new NameValuePair[]{new NameValuePair("destination", pathRelativeToBaseUrl), new NameValuePair("os_username", this.getCurrentUserName()), new NameValuePair("os_password", this.getCurrentPassword())});
                Assert.assertEquals((int)200, (int)httpClient.executeMethod((HttpMethod)loginMethod));
                GetMethod getEscalatedPrivsMethod = null;
                InputStream destinationBodyInput = null;
                try {
                    getEscalatedPrivsMethod = new GetMethod(this.getBaseUrl() + "/doauthenticate.action");
                    getEscalatedPrivsMethod.setQueryString(new NameValuePair[]{new NameValuePair("destination", pathRelativeToBaseUrl), new NameValuePair("password", this.getCurrentPassword())});
                    httpClient.executeMethod((HttpMethod)getEscalatedPrivsMethod);
                    destinationBodyInput = getEscalatedPrivsMethod.getResponseBodyAsStream();
                    string2 = this.getXsrfToken(destinationBodyInput);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(destinationBodyInput);
                    if (null != getEscalatedPrivsMethod) {
                        getEscalatedPrivsMethod.releaseConnection();
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)destinationBodyInput);
                if (null != getEscalatedPrivsMethod) {
                    getEscalatedPrivsMethod.releaseConnection();
                }
                return string2;
            }
            finally {
                if (null != loginMethod) {
                    loginMethod.releaseConnection();
                }
            }
        }
        GetMethod loginMethod = null;
        InputStream destinationBodyInput = null;
        try {
            loginMethod = new GetMethod(this.getBaseUrl() + pathRelativeToBaseUrl);
            loginMethod.setQueryString(new NameValuePair[]{new NameValuePair("os_username", this.getCurrentUserName()), new NameValuePair("os_password", this.getCurrentPassword())});
            httpClient.executeMethod((HttpMethod)loginMethod);
            destinationBodyInput = loginMethod.getResponseBodyAsStream();
            string = this.getXsrfToken(destinationBodyInput);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(destinationBodyInput);
            if (null != loginMethod) {
                loginMethod.releaseConnection();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)destinationBodyInput);
        if (null != loginMethod) {
            loginMethod.releaseConnection();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutWithHttpClient(HttpClient httpClient) {
        GetMethod logoutMethod = new GetMethod(this.getBaseUrl() + "/logout.action");
        try {
            httpClient.executeMethod((HttpMethod)logoutMethod);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Unable to logout with HttpClient.", (Throwable)ioe);
        }
        finally {
            logoutMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(HttpClient httpClient, String path, Map<String, String[]> params, String fileParamName, File file, HttpClientCallback<PostMethod> httpClientCallback) throws IOException {
        PostMethod postMethod = new PostMethod(this.getBaseUrl() + path);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (null != params) {
            for (Map.Entry<String, String[]> e : params.entrySet()) {
                String name = e.getKey();
                String[] values = e.getValue();
                if (!StringUtils.isNotBlank((String)name) || null == values || values.length <= 0) continue;
                for (String value : values) {
                    parts.add(new StringPart(name, value));
                }
            }
        }
        parts.add(new FilePart(fileParamName, file));
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), (HttpMethodParams)httpClient.getParams()));
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (null != httpClientCallback) {
                httpClientCallback.handle(httpClient, statusCode, postMethod);
            }
        }
        finally {
            postMethod.releaseConnection();
            this.logoutWithHttpClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPluginInternal(File pluginJar) {
        HttpClient httpClient = new HttpClient();
        try {
            final String pluginName = PluginMetadataUtil.getPluginName(PluginMetadataUtil.getPluginDescriptorDom(pluginJar));
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("atl_token", new String[]{this.loginToLocationWithEscalatedPrivileges(httpClient, "/admin/olduploadplugin.action")});
            this.uploadFile(httpClient, "/admin/olduploadplugin.action", params, "file_0", pluginJar, new HttpClientCallback<PostMethod>(){

                @Override
                public void handle(HttpClient httpClient, int statusCode, PostMethod uploadMethod) {
                    Assert.assertEquals((int)302, (int)statusCode);
                    String location = uploadMethod.getResponseHeader("Location").getValue();
                    GetMethod getPluginDetailsPage = new GetMethod(location);
                    try {
                        Assert.assertEquals((int)200, (int)httpClient.executeMethod((HttpMethod)getPluginDetailsPage));
                        Assert.assertTrue((getPluginDetailsPage.getResponseBodyAsString().indexOf(pluginName) >= 0 ? 1 : 0) != 0);
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)("Unable to load plugin list page at " + location), (Throwable)ioe);
                        Assert.fail((String)("Unable to load plugin list page at " + location));
                    }
                }
            });
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to get plugin name from plugin JAR at " + pluginJar + "\n" + ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
        finally {
            this.logoutWithHttpClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreData() {
        File configuredSiteExport = this.testerConfiguration.getSiteBackupZip();
        File siteExportZip = null;
        try {
            if (null != configuredSiteExport) {
                this.restoreData(configuredSiteExport);
            } else {
                siteExportZip = ClasspathResourceUtil.getClassPathResourceAsTempFile("site-export.zip", this.getClass().getClassLoader(), ".zip");
                if (null != siteExportZip) {
                    this.restoreData(siteExportZip);
                }
            }
        }
        catch (IOException ioe) {
            Assert.fail((String)("Unable to restore class path site-export.zip: " + ioe.getMessage()));
        }
        finally {
            if (null != siteExportZip && siteExportZip.exists()) {
                Assert.assertTrue((String)("Unable to delete " + siteExportZip), (boolean)siteExportZip.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreData(File exportZip) {
        HttpClient httpClient = new HttpClient();
        if (null != exportZip && exportZip.isFile()) {
            try {
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                params.put("synchronous", new String[]{"true"});
                params.put("atl_token", new String[]{this.loginToLocationWithEscalatedPrivileges(httpClient, "/admin/restore.action")});
                this.uploadFile(httpClient, "/admin/restore.action", params, "file_0", exportZip, new HttpClientCallback<PostMethod>(){

                    @Override
                    public void handle(HttpClient httpClient, int statusCode, PostMethod uploadMethod) {
                        Assert.assertEquals((int)302, (int)statusCode);
                        SeleniumConfluenceWebTester.this.open(SeleniumConfluenceWebTester.this.getUrl("/admin/editgeneralconfig.action"));
                        SeleniumConfluenceWebTester.this.type("css=form[name='editgeneralconfig'] input[name='domainName']", SeleniumConfluenceWebTester.this.getBaseUrl());
                        SeleniumConfluenceWebTester.this.submit("css=form[name='editgeneralconfig']");
                        SeleniumConfluenceWebTester.this.waitForPageToLoad();
                        HelperFactory.createIndexHelper(SeleniumConfluenceWebTester.this).update();
                    }
                });
            }
            catch (IOException ioe) {
                LOG.error((Object)("Unable to restore " + exportZip), (Throwable)ioe);
                Assert.fail((String)("Unable to restore " + exportZip));
            }
            finally {
                this.logoutWithHttpClient(httpClient);
            }
        } else {
            LOG.warn((Object)("Unable to find export file: " + exportZip + ". Skipping data restoration."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCaches() {
        try {
            Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/cachestatistics.action"));
            String atlassianToken = null;
            String atlassianTokenXpath = "//meta[@id='atlassian-token']";
            if (this.isElementPresent(atlassianTokenXpath)) {
                atlassianToken = this.getAttribute("xpath=" + atlassianTokenXpath + "/@content");
            }
            this.gotoPageWithEscalatedPrivileges("/admin/flushcache.action" + (StringUtils.isBlank(atlassianToken) ? "" : "?atl_token=" + atlassianToken));
            this.waitForPageToLoad();
        }
        finally {
            this.dropEscalatedPrivileges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String assertXsrfStatusCode(String resourcePath) {
        StringBuilder urlWithOsAuthTypeReplacedBuilder = new StringBuilder(this.getBaseUrl()).append(resourcePath.replaceAll("(.*[?&])(os_authType=\\w*)(.*)", "$1os_authType=basic$3"));
        if (urlWithOsAuthTypeReplacedBuilder.indexOf("os_authType") < 0) {
            urlWithOsAuthTypeReplacedBuilder.append(urlWithOsAuthTypeReplacedBuilder.indexOf("?") < 0 ? (char)'?' : '&').append("os_authType=basic");
        }
        HttpClient client = new HttpClient();
        GetMethod httpGet = new GetMethod(urlWithOsAuthTypeReplacedBuilder.toString());
        try {
            client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.getCurrentUserName(), this.getCurrentPassword()));
            httpGet.setDoAuthentication(true);
            Assert.assertEquals((int)403, (int)client.executeMethod((HttpMethod)httpGet));
            String string = httpGet.getResponseBodyAsString();
            return string;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error getting HTTP resource " + urlWithOsAuthTypeReplacedBuilder), (Throwable)ioe);
            String string = null;
            return string;
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    @Override
    public void assertResourceXsrfProtected(String resourcePath) {
        Assert.assertFalse((String)("No body text returned for " + resourcePath), (boolean)StringUtils.isBlank((String)this.assertXsrfStatusCode(resourcePath)));
    }

    @Override
    public void assertXsrfTokenNotPresentFailure(String resourcePath) {
        Assert.assertTrue((this.assertXsrfStatusCode(resourcePath).indexOf("a required security token was not present") >= 0 ? 1 : 0) != 0);
    }

    @Override
    public void assertXsrfTokenNotValidFailure(String resourcePath) {
        Assert.assertTrue((this.assertXsrfStatusCode(resourcePath).indexOf("Your session has expired. You may need to re-submit the form or reload the page.") >= 0 ? 1 : 0) != 0);
    }

    @Override
    public boolean gotoPageWithEscalatedPrivileges(String destination) {
        return this.gotoPageWithEscalatedPrivileges(destination, "UTF-8");
    }

    @Override
    public boolean gotoPageWithEscalatedPrivileges(String destination, String urlEncoding) {
        if (ConfluenceBuildUtil.containsSudoFeature() && !this.isElementPresent("css=#confluence-message-websudo-message")) {
            try {
                this.open(this.getUrl("/authenticate.action?destination=" + URLEncoder.encode(destination, urlEncoding)));
                this.waitForPageToLoad();
                this.type("xpath=//input[@name='password']", this.getCurrentPassword());
                this.click("xpath=//input[@name='authenticate']");
                this.waitForPageToLoad();
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error((Object)("Unable to URL encode " + destination + " with " + urlEncoding), (Throwable)uee);
                return false;
            }
        } else {
            this.open(this.getUrl(destination));
            this.waitForPageToLoad();
        }
        return true;
    }

    @Override
    public void dropEscalatedPrivileges() {
        if (ConfluenceBuildUtil.containsSudoFeature() && this.isElementPresent("css=#confluence-message-websudo-message]")) {
            this.open(this.getUrl("/dropauthentication.action"));
            this.waitForPageToLoad();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HttpClientCallback<T extends HttpMethodBase> {
        public void handle(HttpClient var1, int var2, T var3);
    }
}

