/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.rpc;

import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.user.User;
import java.io.File;
import java.io.IOException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class PdfExportRpcDelegatorImpl {
    private SpaceManager spaceManager;
    private PermissionManager permissionManager;
    private ImportExportManager importExportManager;
    private PdfExporterService pdfExporterService;
    private GateKeeper gateKeeper;
    private SettingsManager settingsManager;
    private PlatformTransactionManager transactionManager;

    public String exportSpace(final String spaceKey) throws RemoteException {
        TransactionTemplate tt = new TransactionTemplate();
        tt.setTransactionManager(this.transactionManager);
        Object obj = tt.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                String downloadPath;
                Space space = PdfExportRpcDelegatorImpl.this.spaceManager.getSpace(spaceKey);
                if (space == null) {
                    return new RemoteException("Invalid spaceKey: [" + spaceKey + "]");
                }
                User user = AuthenticatedUserThreadLocal.getUser();
                if (!PdfExportRpcDelegatorImpl.this.hasPermission(user, Permission.EXPORT, space)) {
                    return new NotPermittedException("You don't have permission to export the space: " + space.getKey());
                }
                ContentTree contentTree = PdfExportRpcDelegatorImpl.this.importExportManager.getContentTree(user, space);
                try {
                    String contextPath = ServletContextThreadLocal.getRequest().getContextPath();
                    File pdfFile = PdfExportRpcDelegatorImpl.this.pdfExporterService.createPdfForSpace(user, space, contentTree, contextPath);
                    downloadPath = PdfExportRpcDelegatorImpl.this.importExportManager.prepareDownloadPath(pdfFile.getAbsolutePath());
                    PdfExportRpcDelegatorImpl.this.gateKeeper.addKey(downloadPath, user);
                }
                catch (ImportExportException e) {
                    return new RemoteException(e.getMessage());
                }
                catch (IOException e) {
                    return new RemoteException(e.getMessage());
                }
                return downloadPath;
            }
        });
        if (obj instanceof RemoteException) {
            throw (RemoteException)obj;
        }
        String downloadPath = (String)obj;
        return this.settingsManager.getGlobalSettings().getBaseUrl() + downloadPath;
    }

    private boolean hasPermission(User user, Permission permission, Space space) {
        return this.isSuperUser(user) || this.permissionManager.hasPermission(user, permission, (Object)space);
    }

    protected boolean isSuperUser(User user) {
        return GeneralUtil.isSuperUser((User)user);
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setFlyingPdfExporterService(PdfExporterService pdfExporterService) {
        this.pdfExporterService = pdfExporterService;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

